/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui.about;

import ai.org.jfree.base.Library;
import ai.org.jfree.ui.about.LibraryTableModel;
import ai.org.jfree.ui.about.ProjectInfo;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class LibraryPanel
extends JPanel {
    private JTable table;
    private LibraryTableModel model;

    public LibraryPanel(List list) {
        this.setLayout(new BorderLayout());
        this.model = new LibraryTableModel(list);
        this.table = new JTable(this.model);
        this.add(new JScrollPane(this.table));
    }

    public LibraryPanel(ProjectInfo projectInfo) {
        this(LibraryPanel.getLibraries(projectInfo));
    }

    private static List getLibraries(ProjectInfo projectInfo) {
        if (projectInfo == null) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        LibraryPanel.collectLibraries(projectInfo, arrayList);
        return arrayList;
    }

    private static void collectLibraries(ProjectInfo projectInfo, List list) {
        Library library;
        int n;
        Library[] libraryArray = projectInfo.getLibraries();
        for (n = 0; n < libraryArray.length; ++n) {
            library = libraryArray[n];
            if (list.contains(library)) continue;
            list.add(library);
            if (!(library instanceof ProjectInfo)) continue;
            LibraryPanel.collectLibraries((ProjectInfo)library, list);
        }
        libraryArray = projectInfo.getOptionalLibraries();
        for (n = 0; n < libraryArray.length; ++n) {
            library = libraryArray[n];
            if (list.contains(library)) continue;
            list.add(library);
            if (!(library instanceof ProjectInfo)) continue;
            LibraryPanel.collectLibraries((ProjectInfo)library, list);
        }
    }

    public LibraryTableModel getModel() {
        return this.model;
    }

    protected JTable getTable() {
        return this.table;
    }
}

