/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui;

import ai.org.jfree.ui.NumberCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RefineryUtilities {
    private RefineryUtilities() {
    }

    public static Point getCenterPoint() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = GraphicsEnvironment.class.getMethod("getCenterPoint", null);
            return (Point)method.invoke((Object)graphicsEnvironment, (Object[])null);
        }
        catch (Exception exception) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            return new Point(dimension.width / 2, dimension.height / 2);
        }
    }

    public static Rectangle getMaximumWindowBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Method method = GraphicsEnvironment.class.getMethod("getMaximumWindowBounds", null);
            return (Rectangle)method.invoke((Object)graphicsEnvironment, (Object[])null);
        }
        catch (Exception exception) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }
    }

    public static void centerFrameOnScreen(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window window, double d, double d2) {
        Rectangle rectangle = window.getGraphicsConfiguration().getBounds();
        Dimension dimension = window.getSize();
        int n = Math.max(rectangle.width - dimension.width, 0);
        int n2 = Math.max(rectangle.height - dimension.height, 0);
        int n3 = (int)(d * (double)n) + rectangle.x;
        int n4 = (int)(d2 * (double)n2) + rectangle.y;
        window.setBounds(n3, n4, dimension.width, dimension.height);
    }

    public static void positionFrameRandomly(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double d, double d2) {
        Container container = dialog.getParent();
        if (container == null) {
            RefineryUtilities.centerFrameOnScreen(dialog);
            return;
        }
        Dimension dimension = dialog.getSize();
        Dimension dimension2 = container.getSize();
        int n = container.getX();
        int n2 = container.getY();
        int n3 = n + (int)(d * (double)dimension2.width);
        int n4 = n2 + (int)(d2 * (double)dimension2.height);
        Rectangle rectangle = container.getGraphicsConfiguration().getBounds();
        Rectangle rectangle2 = new Rectangle(n3, n4, dimension.width, dimension.height);
        dialog.setBounds(rectangle2.intersection(rectangle));
    }

    public static JPanel createTablePanel(TableModel tableModel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(tableModel);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            Class<?> clazz = tableModel.getColumnClass(i);
            if (!clazz.equals(Number.class)) continue;
            tableColumn.setCellRenderer(new NumberCellRenderer());
        }
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    public static JLabel createJLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }

    public static JLabel createJLabel(String string, Font font, Color color) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setForeground(color);
        return jLabel;
    }

    public static JButton createJButton(String string, Font font) {
        JButton jButton = new JButton(string);
        jButton.setFont(font);
        return jButton;
    }
}

