/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.text;

import ai.org.jfree.text.TextFragment;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.ui.TextAnchor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TextLine
implements Serializable {
    private static final long serialVersionUID = 7100085690160465444L;
    private List fragments;

    public TextLine() {
        this.fragments = new ArrayList();
    }

    public TextLine(String string) {
        this(string, TextFragment.DEFAULT_FONT);
    }

    public TextLine(String string, Font font) {
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font);
        this.fragments.add(textFragment);
    }

    public TextLine(String string, Font font, Paint paint) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font, paint);
        this.fragments.add(textFragment);
    }

    public void addFragment(TextFragment textFragment) {
        this.fragments.add(textFragment);
    }

    public void removeFragment(TextFragment textFragment) {
        this.fragments.remove(textFragment);
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        float f5 = f;
        float f6 = this.calculateBaselineOffset(graphics2D, textAnchor);
        for (TextFragment textFragment : this.fragments) {
            Size2D size2D = textFragment.calculateDimensions(graphics2D);
            textFragment.draw(graphics2D, f5, f2 + f6, TextAnchor.BASELINE_LEFT, f3, f4, d);
            f5 += (float)size2D.getWidth();
        }
    }

    public Size2D calculateDimensions(Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        for (TextFragment textFragment : this.fragments) {
            Size2D size2D = textFragment.calculateDimensions(graphics2D);
            d += size2D.getWidth();
            d2 = Math.max(d2, size2D.getHeight());
        }
        return new Size2D(d, d2);
    }

    public TextFragment getFirstTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(0);
        }
        return textFragment;
    }

    public TextFragment getLastTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(this.fragments.size() - 1);
        }
        return textFragment;
    }

    private float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f = 0.0f;
        for (TextFragment textFragment : this.fragments) {
            f = Math.max(f, textFragment.calculateBaselineOffset(graphics2D, textAnchor));
        }
        return f;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextLine) {
            TextLine textLine = (TextLine)object;
            return this.fragments.equals(textLine.fragments);
        }
        return false;
    }

    public int hashCode() {
        return this.fragments != null ? this.fragments.hashCode() : 0;
    }
}

