/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.text;

import ai.org.jfree.text.TextBlockAnchor;
import ai.org.jfree.text.TextLine;
import ai.org.jfree.ui.HorizontalAlignment;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TextBlock
implements Serializable {
    private static final long serialVersionUID = -4333175719424385526L;
    private List lines = new ArrayList();
    private HorizontalAlignment lineAlignment = HorizontalAlignment.CENTER;

    public HorizontalAlignment getLineAlignment() {
        return this.lineAlignment;
    }

    public void setLineAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("Null 'alignment' argument.");
        }
        this.lineAlignment = horizontalAlignment;
    }

    public void addLine(String string, Font font, Paint paint) {
        this.addLine(new TextLine(string, font, paint));
    }

    public void addLine(TextLine textLine) {
        this.lines.add(textLine);
    }

    public TextLine getLastLine() {
        TextLine textLine = null;
        int n = this.lines.size() - 1;
        if (n >= 0) {
            textLine = (TextLine)this.lines.get(n);
        }
        return textLine;
    }

    public List getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public Size2D calculateDimensions(Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        for (TextLine textLine : this.lines) {
            Size2D size2D = textLine.calculateDimensions(graphics2D);
            d = Math.max(d, size2D.getWidth());
            d2 += size2D.getHeight();
        }
        return new Size2D(d, d2);
    }

    public Shape calculateBounds(Graphics2D graphics2D, float f, float f2, TextBlockAnchor textBlockAnchor, float f3, float f4, double d) {
        Size2D size2D = this.calculateDimensions(graphics2D);
        float[] fArray = this.calculateOffsets(textBlockAnchor, size2D.getWidth(), size2D.getHeight());
        Rectangle2D.Double double_ = new Rectangle2D.Double(f + fArray[0], f2 + fArray[1], size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtilities.rotateShape(double_, d, f3, f4);
        return shape;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextBlockAnchor textBlockAnchor) {
        this.draw(graphics2D, f, f2, textBlockAnchor, 0.0f, 0.0f, 0.0);
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextBlockAnchor textBlockAnchor, float f3, float f4, double d) {
        Size2D size2D = this.calculateDimensions(graphics2D);
        float[] fArray = this.calculateOffsets(textBlockAnchor, size2D.getWidth(), size2D.getHeight());
        Iterator iterator = this.lines.iterator();
        float f5 = 0.0f;
        while (iterator.hasNext()) {
            TextLine textLine = (TextLine)iterator.next();
            Size2D size2D2 = textLine.calculateDimensions(graphics2D);
            float f6 = 0.0f;
            if (this.lineAlignment == HorizontalAlignment.CENTER) {
                f6 = (float)(size2D.getWidth() - size2D2.getWidth()) / 2.0f;
            } else if (this.lineAlignment == HorizontalAlignment.RIGHT) {
                f6 = (float)(size2D.getWidth() - size2D2.getWidth());
            }
            textLine.draw(graphics2D, f + fArray[0] + f6, f2 + fArray[1] + f5, TextAnchor.TOP_LEFT, f3, f4, d);
            f5 += (float)size2D2.getHeight();
        }
    }

    private float[] calculateOffsets(TextBlockAnchor textBlockAnchor, double d, double d2) {
        float[] fArray = new float[2];
        float f = 0.0f;
        float f2 = 0.0f;
        if (textBlockAnchor == TextBlockAnchor.TOP_CENTER || textBlockAnchor == TextBlockAnchor.CENTER || textBlockAnchor == TextBlockAnchor.BOTTOM_CENTER) {
            f = (float)(-d) / 2.0f;
        } else if (textBlockAnchor == TextBlockAnchor.TOP_RIGHT || textBlockAnchor == TextBlockAnchor.CENTER_RIGHT || textBlockAnchor == TextBlockAnchor.BOTTOM_RIGHT) {
            f = (float)(-d);
        }
        if (textBlockAnchor == TextBlockAnchor.TOP_LEFT || textBlockAnchor == TextBlockAnchor.TOP_CENTER || textBlockAnchor == TextBlockAnchor.TOP_RIGHT) {
            f2 = 0.0f;
        } else if (textBlockAnchor == TextBlockAnchor.CENTER_LEFT || textBlockAnchor == TextBlockAnchor.CENTER || textBlockAnchor == TextBlockAnchor.CENTER_RIGHT) {
            f2 = (float)(-d2) / 2.0f;
        } else if (textBlockAnchor == TextBlockAnchor.BOTTOM_LEFT || textBlockAnchor == TextBlockAnchor.BOTTOM_CENTER || textBlockAnchor == TextBlockAnchor.BOTTOM_RIGHT) {
            f2 = (float)(-d2);
        }
        fArray[0] = f;
        fArray[1] = f2;
        return fArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TextBlock) {
            TextBlock textBlock = (TextBlock)object;
            return this.lines.equals(textBlock.lines);
        }
        return false;
    }

    public int hashCode() {
        return this.lines != null ? this.lines.hashCode() : 0;
    }
}

