/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.date.junit;

import ai.org.jfree.date.SerialDate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SerialDateTests
extends TestCase {
    private SerialDate nov9Y2001;

    public SerialDateTests(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(SerialDateTests.class);
    }

    protected void setUp() {
        this.nov9Y2001 = SerialDate.createInstance(9, 11, 2001);
    }

    public void testAddMonthsTo9Nov2001() {
        SerialDate serialDate = SerialDate.addMonths(2, this.nov9Y2001);
        SerialDate serialDate2 = SerialDate.createInstance(9, 1, 2002);
        SerialDateTests.assertEquals((Object)serialDate2, (Object)serialDate);
    }

    public void testAddMonthsTo5Oct2003() {
        SerialDate serialDate = SerialDate.createInstance(5, 10, 2003);
        SerialDate serialDate2 = SerialDate.addMonths(2, serialDate);
        SerialDateTests.assertEquals((Object)serialDate2, (Object)SerialDate.createInstance(5, 12, 2003));
    }

    public void testAddMonthsTo1Jan2003() {
        SerialDate serialDate = SerialDate.createInstance(1, 1, 2003);
        SerialDate serialDate2 = SerialDate.addMonths(0, serialDate);
        SerialDateTests.assertEquals((Object)serialDate2, (Object)serialDate);
    }

    public void testMondayPrecedingFriday9Nov2001() {
        SerialDate serialDate = SerialDate.getPreviousDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals((int)5, (int)serialDate.getDayOfMonth());
    }

    public void testMondayFollowingFriday9Nov2001() {
        SerialDate serialDate = SerialDate.getFollowingDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals((int)12, (int)serialDate.getDayOfMonth());
    }

    public void testMondayNearestFriday9Nov2001() {
        SerialDate serialDate = SerialDate.getNearestDayOfWeek(2, this.nov9Y2001);
        SerialDateTests.assertEquals((int)12, (int)serialDate.getDayOfMonth());
    }

    public void testMondayNearest22Jan1970() {
        SerialDate serialDate = SerialDate.createInstance(22, 1, 1970);
        SerialDate serialDate2 = SerialDate.getNearestDayOfWeek(2, serialDate);
        SerialDateTests.assertEquals((int)19, (int)serialDate2.getDayOfMonth());
    }

    public void testWeekdayCodeToString() {
        String string = SerialDate.weekdayCodeToString(7);
        SerialDateTests.assertEquals((String)"Saturday", (String)string);
    }

    public void testStringToWeekday() {
        int n = SerialDate.stringToWeekdayCode("Wednesday");
        SerialDateTests.assertEquals((int)4, (int)n);
        n = SerialDate.stringToWeekdayCode(" Wednesday ");
        SerialDateTests.assertEquals((int)4, (int)n);
        n = SerialDate.stringToWeekdayCode("Wed");
        SerialDateTests.assertEquals((int)4, (int)n);
    }

    public void testStringToMonthCode() {
        int n = SerialDate.stringToMonthCode("January");
        SerialDateTests.assertEquals((int)1, (int)n);
        n = SerialDate.stringToMonthCode(" January ");
        SerialDateTests.assertEquals((int)1, (int)n);
        n = SerialDate.stringToMonthCode("Jan");
        SerialDateTests.assertEquals((int)1, (int)n);
    }

    public void testMonthCodeToStringCode() {
        String string = SerialDate.monthCodeToString(12);
        SerialDateTests.assertEquals((String)"December", (String)string);
    }

    public void testIsNotLeapYear1900() {
        SerialDateTests.assertTrue((!SerialDate.isLeapYear(1900) ? 1 : 0) != 0);
    }

    public void testIsLeapYear2000() {
        SerialDateTests.assertTrue((boolean)SerialDate.isLeapYear(2000));
    }

    public void testLeapYearCount1899() {
        SerialDateTests.assertEquals((int)SerialDate.leapYearCount(1899), (int)0);
    }

    public void testLeapYearCount1903() {
        SerialDateTests.assertEquals((int)SerialDate.leapYearCount(1903), (int)0);
    }

    public void testLeapYearCount1904() {
        SerialDateTests.assertEquals((int)SerialDate.leapYearCount(1904), (int)1);
    }

    public void testLeapYearCount1999() {
        SerialDateTests.assertEquals((int)SerialDate.leapYearCount(1999), (int)24);
    }

    public void testLeapYearCount2000() {
        SerialDateTests.assertEquals((int)SerialDate.leapYearCount(2000), (int)25);
    }

    public void testSerialization() {
        SerialDate serialDate = SerialDate.createInstance(15, 4, 2000);
        SerialDate serialDate2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serialDate);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            serialDate2 = (SerialDate)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialDateTests.assertEquals((Object)serialDate, serialDate2);
    }

    public void test1096282() {
        SerialDate serialDate = SerialDate.createInstance(29, 2, 2004);
        serialDate = SerialDate.addYears(1, serialDate);
        SerialDate serialDate2 = SerialDate.createInstance(28, 2, 2005);
        SerialDateTests.assertTrue((boolean)serialDate.isOn(serialDate2));
    }

    public void testAddMonths() {
        SerialDate serialDate = SerialDate.createInstance(31, 5, 2004);
        SerialDate serialDate2 = SerialDate.addMonths(1, serialDate);
        SerialDateTests.assertEquals((int)30, (int)serialDate2.getDayOfMonth());
        SerialDateTests.assertEquals((int)6, (int)serialDate2.getMonth());
        SerialDateTests.assertEquals((int)2004, (int)serialDate2.getYYYY());
        SerialDate serialDate3 = SerialDate.addMonths(2, serialDate);
        SerialDateTests.assertEquals((int)31, (int)serialDate3.getDayOfMonth());
        SerialDateTests.assertEquals((int)7, (int)serialDate3.getMonth());
        SerialDateTests.assertEquals((int)2004, (int)serialDate3.getYYYY());
        SerialDate serialDate4 = SerialDate.addMonths(1, SerialDate.addMonths(1, serialDate));
        SerialDateTests.assertEquals((int)30, (int)serialDate4.getDayOfMonth());
        SerialDateTests.assertEquals((int)7, (int)serialDate4.getMonth());
        SerialDateTests.assertEquals((int)2004, (int)serialDate4.getYYYY());
    }
}

