/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.date;

import ai.org.jfree.date.AnnualDateRule;
import ai.org.jfree.date.SerialDate;

public class DayAndMonthRule
extends AnnualDateRule {
    private int dayOfMonth;
    private int month;

    public DayAndMonthRule() {
        this(1, 1);
    }

    public DayAndMonthRule(int n, int n2) {
        this.setMonth(n2);
        this.setDayOfMonth(n);
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int n) {
        if (n < 1 || n > SerialDate.LAST_DAY_OF_MONTH[this.month]) {
            throw new IllegalArgumentException("DayAndMonthRule(): dayOfMonth outside valid range.");
        }
        this.dayOfMonth = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        if (!SerialDate.isValidMonthCode(n)) {
            throw new IllegalArgumentException("DayAndMonthRule(): month code not valid.");
        }
        this.month = n;
    }

    public SerialDate getDate(int n) {
        return SerialDate.createInstance(this.dayOfMonth, this.month, n);
    }
}

