/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.YIntervalSeries;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class YIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(YIntervalSeries yIntervalSeries) {
        if (yIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(yIntervalSeries);
        yIntervalSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public YIntervalSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (YIntervalSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return yIntervalSeries.getX(n2);
    }

    public double getYValue(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return yIntervalSeries.getYValue(n2);
    }

    public double getStartYValue(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return yIntervalSeries.getYLowValue(n2);
    }

    public double getEndYValue(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return yIntervalSeries.getYHighValue(n2);
    }

    public Number getY(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return new Double(yIntervalSeries.getYValue(n2));
    }

    public Number getStartX(int n, int n2) {
        return this.getX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.getX(n, n2);
    }

    public Number getStartY(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return new Double(yIntervalSeries.getYLowValue(n2));
    }

    public Number getEndY(int n, int n2) {
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        return new Double(yIntervalSeries.getYHighValue(n2));
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(n);
        yIntervalSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeSeries(YIntervalSeries yIntervalSeries) {
        if (yIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(yIntervalSeries)) {
            yIntervalSeries.removeChangeListener(this);
            this.data.remove(yIntervalSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            YIntervalSeries yIntervalSeries = (YIntervalSeries)this.data.get(i);
            yIntervalSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof YIntervalSeriesCollection)) {
            return false;
        }
        YIntervalSeriesCollection yIntervalSeriesCollection = (YIntervalSeriesCollection)object;
        return ObjectUtilities.equal(this.data, yIntervalSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        YIntervalSeriesCollection yIntervalSeriesCollection = (YIntervalSeriesCollection)super.clone();
        yIntervalSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return yIntervalSeriesCollection;
    }
}

