/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.util.ParamChecks;
import ai.org.jfree.data.DomainInfo;
import ai.org.jfree.data.DomainOrder;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.RangeInfo;
import ai.org.jfree.data.UnknownKeyException;
import ai.org.jfree.data.general.Series;
import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDelegate;
import ai.org.jfree.data.xy.XYSeries;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo,
VetoableChangeListener,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        this.addChangeListener(this.intervalDelegate);
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
            xYSeries.addVetoableChangeListener(this);
        }
    }

    public DomainOrder getDomainOrder() {
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            if (xYSeries.getAutoSort()) continue;
            return DomainOrder.NONE;
        }
        return DomainOrder.ASCENDING;
    }

    public void addSeries(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        if (this.getSeriesIndex(xYSeries.getKey()) >= 0) {
            throw new IllegalArgumentException("This dataset already contains a series with the key " + xYSeries.getKey());
        }
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        xYSeries.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
            this.data.remove(xYSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int indexOf(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        return this.data.indexOf(xYSeries);
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(n);
    }

    public XYSeries getSeries(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        for (XYSeries xYSeries : this.data) {
            if (!comparable.equals(xYSeries.getKey())) continue;
            return xYSeries;
        }
        throw new UnknownKeyException("Key not found: " + comparable);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getSeriesIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            if (!comparable.equals(xYSeries.getKey())) continue;
            return i;
        }
        return -1;
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries.getX(n2);
    }

    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    public Number getY(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        return xYSeries.getY(n2);
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)object;
        if (!this.intervalDelegate.equals(xYSeriesCollection.intervalDelegate)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)super.clone();
        xYSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        xYSeriesCollection.intervalDelegate = (IntervalXYDelegate)this.intervalDelegate.clone();
        return xYSeriesCollection;
    }

    public int hashCode() {
        int n = 5;
        n = HashUtilities.hashCode(n, this.intervalDelegate);
        n = HashUtilities.hashCode(n, this.data);
        return n;
    }

    public double getDomainLowerBound(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainLowerBound(bl);
        }
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMinX();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.min(d, d2);
        }
        return d;
    }

    public double getDomainUpperBound(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainUpperBound(bl);
        }
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMaxX();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        return d;
    }

    public Range getDomainBounds(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainBounds(bl);
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            double d3;
            XYSeries xYSeries = this.getSeries(i);
            double d4 = xYSeries.getMinX();
            if (!Double.isNaN(d4)) {
                d = Math.min(d, d4);
            }
            if (Double.isNaN(d3 = xYSeries.getMaxX())) continue;
            d2 = Math.max(d2, d3);
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }

    public Range getRangeBounds(boolean bl) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            double d3;
            XYSeries xYSeries = this.getSeries(i);
            double d4 = xYSeries.getMinY();
            if (!Double.isNaN(d4)) {
                d = Math.min(d, d4);
            }
            if (Double.isNaN(d3 = xYSeries.getMaxY())) continue;
            d2 = Math.max(d2, d3);
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMinY();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.min(d, d2);
        }
        return d;
    }

    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        int n = this.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            XYSeries xYSeries = this.getSeries(i);
            double d2 = xYSeries.getMaxY();
            if (Double.isNaN(d)) {
                d = d2;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        return d;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!"Key".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Series series = (Series)propertyChangeEvent.getSource();
        if (this.getSeries(series.getKey()) == null) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable comparable = (Comparable)propertyChangeEvent.getNewValue();
        if (this.getSeries(comparable) != null) {
            throw new PropertyVetoException("Duplicate key2", propertyChangeEvent);
        }
    }
}

