/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYIntervalSeries;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(XYIntervalSeries xYIntervalSeries) {
        if (xYIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(xYIntervalSeries);
        xYIntervalSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public XYIntervalSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYIntervalSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getX(n2);
    }

    public double getStartXValue(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getXLowValue(n2);
    }

    public double getEndXValue(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getXHighValue(n2);
    }

    public double getYValue(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getYValue(n2);
    }

    public double getStartYValue(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getYLowValue(n2);
    }

    public double getEndYValue(int n, int n2) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        return xYIntervalSeries.getYHighValue(n2);
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public Number getStartX(int n, int n2) {
        return new Double(this.getStartXValue(n, n2));
    }

    public Number getEndX(int n, int n2) {
        return new Double(this.getEndXValue(n, n2));
    }

    public Number getStartY(int n, int n2) {
        return new Double(this.getStartYValue(n, n2));
    }

    public Number getEndY(int n, int n2) {
        return new Double(this.getEndYValue(n, n2));
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n);
        xYIntervalSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeSeries(XYIntervalSeries xYIntervalSeries) {
        if (xYIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xYIntervalSeries)) {
            xYIntervalSeries.removeChangeListener(this);
            this.data.remove(xYIntervalSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(i);
            xYIntervalSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYIntervalSeriesCollection)) {
            return false;
        }
        XYIntervalSeriesCollection xYIntervalSeriesCollection = (XYIntervalSeriesCollection)object;
        return ObjectUtilities.equal(this.data, xYIntervalSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        XYIntervalSeriesCollection xYIntervalSeriesCollection = (XYIntervalSeriesCollection)super.clone();
        int n = this.getSeriesCount();
        xYIntervalSeriesCollection.data = new ArrayList(n);
        for (int i = 0; i < this.data.size(); ++i) {
            xYIntervalSeriesCollection.data.set(i, this.getSeries(i).clone());
        }
        return xYIntervalSeriesCollection;
    }
}

