/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.xy.TableXYDataset;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class XYDatasetTableModel
extends AbstractTableModel
implements TableModel,
DatasetChangeListener {
    TableXYDataset model = null;

    public XYDatasetTableModel() {
    }

    public XYDatasetTableModel(TableXYDataset tableXYDataset) {
        this();
        this.model = tableXYDataset;
        this.model.addChangeListener(this);
    }

    public void setModel(TableXYDataset tableXYDataset) {
        this.model = tableXYDataset;
        this.model.addChangeListener(this);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getItemCount();
    }

    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getSeriesCount() + 1;
    }

    public String getColumnName(int n) {
        if (this.model == null) {
            return super.getColumnName(n);
        }
        if (n < 1) {
            return "X Value";
        }
        return this.model.getSeriesKey(n - 1).toString();
    }

    public Object getValueAt(int n, int n2) {
        if (this.model == null) {
            return null;
        }
        if (n2 < 1) {
            return this.model.getX(0, n);
        }
        return this.model.getY(n2 - 1, n);
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.isCellEditable(n, n2)) {
            // empty if block
        }
    }
}

