/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;

public class XYBarDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DatasetChangeListener,
PublicCloneable {
    private XYDataset underlying;
    private double barWidth;

    public XYBarDataset(XYDataset xYDataset, double d) {
        this.underlying = xYDataset;
        this.underlying.addChangeListener(this);
        this.barWidth = d;
    }

    public XYDataset getUnderlyingDataset() {
        return this.underlying;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double d) {
        this.barWidth = d;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    public Comparable getSeriesKey(int n) {
        return this.underlying.getSeriesKey(n);
    }

    public int getItemCount(int n) {
        return this.underlying.getItemCount(n);
    }

    public Number getX(int n, int n2) {
        return this.underlying.getX(n, n2);
    }

    public double getXValue(int n, int n2) {
        return this.underlying.getXValue(n, n2);
    }

    public Number getY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public double getYValue(int n, int n2) {
        return this.underlying.getYValue(n, n2);
    }

    public Number getStartX(int n, int n2) {
        Double d = null;
        Number number = this.underlying.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() - this.barWidth / 2.0);
        }
        return d;
    }

    public double getStartXValue(int n, int n2) {
        return this.getXValue(n, n2) - this.barWidth / 2.0;
    }

    public Number getEndX(int n, int n2) {
        Double d = null;
        Number number = this.underlying.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() + this.barWidth / 2.0);
        }
        return d;
    }

    public double getEndXValue(int n, int n2) {
        return this.getXValue(n, n2) + this.barWidth / 2.0;
    }

    public Number getStartY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public double getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public double getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.notifyListeners(datasetChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBarDataset)) {
            return false;
        }
        XYBarDataset xYBarDataset = (XYBarDataset)object;
        if (!this.underlying.equals(xYBarDataset.underlying)) {
            return false;
        }
        return this.barWidth == xYBarDataset.barWidth;
    }

    public Object clone() throws CloneNotSupportedException {
        XYBarDataset xYBarDataset = (XYBarDataset)super.clone();
        if (this.underlying instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.underlying);
            xYBarDataset.underlying = (XYDataset)publicCloneable.clone();
        }
        return xYBarDataset;
    }
}

