/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XIntervalDataItem;
import ai.org.jfree.data.xy.XIntervalSeries;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(XIntervalSeries xIntervalSeries) {
        if (xIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(xIntervalSeries);
        xIntervalSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public XIntervalSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XIntervalSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        XIntervalDataItem xIntervalDataItem = (XIntervalDataItem)xIntervalSeries.getDataItem(n2);
        return xIntervalDataItem.getX();
    }

    public double getStartXValue(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        return xIntervalSeries.getXLowValue(n2);
    }

    public double getEndXValue(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        return xIntervalSeries.getXHighValue(n2);
    }

    public double getYValue(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        return xIntervalSeries.getYValue(n2);
    }

    public Number getY(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        XIntervalDataItem xIntervalDataItem = (XIntervalDataItem)xIntervalSeries.getDataItem(n2);
        return new Double(xIntervalDataItem.getYValue());
    }

    public Number getStartX(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        XIntervalDataItem xIntervalDataItem = (XIntervalDataItem)xIntervalSeries.getDataItem(n2);
        return new Double(xIntervalDataItem.getXLowValue());
    }

    public Number getEndX(int n, int n2) {
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        XIntervalDataItem xIntervalDataItem = (XIntervalDataItem)xIntervalSeries.getDataItem(n2);
        return new Double(xIntervalDataItem.getXHighValue());
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(n);
        xIntervalSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeSeries(XIntervalSeries xIntervalSeries) {
        if (xIntervalSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xIntervalSeries)) {
            xIntervalSeries.removeChangeListener(this);
            this.data.remove(xIntervalSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XIntervalSeries xIntervalSeries = (XIntervalSeries)this.data.get(i);
            xIntervalSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XIntervalSeriesCollection)) {
            return false;
        }
        XIntervalSeriesCollection xIntervalSeriesCollection = (XIntervalSeriesCollection)object;
        return ObjectUtilities.equal(this.data, xIntervalSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        XIntervalSeriesCollection xIntervalSeriesCollection = (XIntervalSeriesCollection)super.clone();
        xIntervalSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return xIntervalSeriesCollection;
    }
}

