/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.xy.AbstractXYDataset;
import ai.org.jfree.data.xy.Vector;
import ai.org.jfree.data.xy.VectorDataItem;
import ai.org.jfree.data.xy.VectorSeries;
import ai.org.jfree.data.xy.VectorXYDataset;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VectorSeriesCollection
extends AbstractXYDataset
implements VectorXYDataset,
PublicCloneable,
Serializable {
    private List data = new ArrayList();

    public void addSeries(VectorSeries vectorSeries) {
        if (vectorSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(vectorSeries);
        vectorSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean removeSeries(VectorSeries vectorSeries) {
        if (vectorSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        boolean bl = this.data.remove(vectorSeries);
        if (bl) {
            vectorSeries.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return bl;
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            VectorSeries vectorSeries = (VectorSeries)this.data.get(i);
            vectorSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (VectorSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int indexOf(VectorSeries vectorSeries) {
        if (vectorSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        return this.data.indexOf(vectorSeries);
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public double getXValue(int n, int n2) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n2);
        return vectorDataItem.getXValue();
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public double getYValue(int n, int n2) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n2);
        return vectorDataItem.getYValue();
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public Vector getVector(int n, int n2) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n2);
        return vectorDataItem.getVector();
    }

    public double getVectorXValue(int n, int n2) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n2);
        return vectorDataItem.getVectorX();
    }

    public double getVectorYValue(int n, int n2) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n2);
        return vectorDataItem.getVectorY();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection vectorSeriesCollection = (VectorSeriesCollection)object;
        return ObjectUtilities.equal(this.data, vectorSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        VectorSeriesCollection vectorSeriesCollection = (VectorSeriesCollection)super.clone();
        vectorSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return vectorSeriesCollection;
    }
}

