/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.general.Series;
import java.io.Serializable;

public class MatrixSeries
extends Series
implements Serializable {
    private static final long serialVersionUID = 7934188527308315704L;
    protected double[][] data;

    public MatrixSeries(String string, int n, int n2) {
        super((Comparable)((Object)string));
        this.data = new double[n][n2];
        this.zeroAll();
    }

    public int getColumnsCount() {
        return this.data[0].length;
    }

    public Number getItem(int n) {
        int n2 = this.getItemRow(n);
        int n3 = this.getItemColumn(n);
        Double d = new Double(this.get(n2, n3));
        return d;
    }

    public int getItemColumn(int n) {
        return n % this.getColumnsCount();
    }

    public int getItemCount() {
        return this.getRowCount() * this.getColumnsCount();
    }

    public int getItemRow(int n) {
        return n / this.getColumnsCount();
    }

    public int getRowCount() {
        return this.data.length;
    }

    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    public void update(int n, int n2, double d) {
        this.data[n][n2] = d;
        this.fireSeriesChanged();
    }

    public void zeroAll() {
        int n = this.getRowCount();
        int n2 = this.getColumnsCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.data[i][j] = 0.0;
            }
        }
        this.fireSeriesChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatrixSeries)) {
            return false;
        }
        MatrixSeries matrixSeries = (MatrixSeries)object;
        if (this.getRowCount() != matrixSeries.getRowCount()) {
            return false;
        }
        if (this.getColumnsCount() != matrixSeries.getColumnsCount()) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnsCount(); ++j) {
                if (this.get(i, j) == matrixSeries.get(i, j)) continue;
                return false;
            }
        }
        return super.equals(object);
    }
}

