/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.DomainOrder;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.xy.AbstractXYZDataset;
import ai.org.jfree.data.xy.XYZDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultXYZDataset
extends AbstractXYZDataset
implements XYZDataset,
PublicCloneable {
    private List seriesKeys = new ArrayList();
    private List seriesList = new ArrayList();

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public Comparable getSeriesKey(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (Comparable)this.seriesKeys.get(n);
    }

    public int indexOf(Comparable comparable) {
        return this.seriesKeys.indexOf(comparable);
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[0].length;
    }

    public double getXValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[0][n2];
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public double getYValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[1][n2];
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public double getZValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[2][n2];
    }

    public Number getZ(int n, int n2) {
        return new Double(this.getZValue(n, n2));
    }

    public void addSeries(Comparable comparable, double[][] dArray) {
        if (comparable == null) {
            throw new IllegalArgumentException("The 'seriesKey' cannot be null.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("The 'data' is null.");
        }
        if (dArray.length != 3) {
            throw new IllegalArgumentException("The 'data' array must have length == 3.");
        }
        if (dArray[0].length != dArray[1].length || dArray[0].length != dArray[2].length) {
            throw new IllegalArgumentException("The 'data' array must contain three arrays all having the same length.");
        }
        int n = this.indexOf(comparable);
        if (n == -1) {
            this.seriesKeys.add(comparable);
            this.seriesList.add(dArray);
        } else {
            this.seriesList.remove(n);
            this.seriesList.add(n, dArray);
        }
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void removeSeries(Comparable comparable) {
        int n = this.indexOf(comparable);
        if (n >= 0) {
            this.seriesKeys.remove(n);
            this.seriesList.remove(n);
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultXYZDataset)) {
            return false;
        }
        DefaultXYZDataset defaultXYZDataset = (DefaultXYZDataset)object;
        if (!this.seriesKeys.equals(defaultXYZDataset.seriesKeys)) {
            return false;
        }
        for (int i = 0; i < this.seriesList.size(); ++i) {
            double[][] dArray;
            double[] dArray2;
            double[][] dArray3 = (double[][])this.seriesList.get(i);
            double[] dArray4 = dArray3[0];
            if (!Arrays.equals(dArray4, dArray2 = (dArray = (double[][])defaultXYZDataset.seriesList.get(i))[0])) {
                return false;
            }
            double[] dArray5 = dArray3[1];
            double[] dArray6 = dArray[1];
            if (!Arrays.equals(dArray5, dArray6)) {
                return false;
            }
            double[] dArray7 = dArray3[2];
            double[] dArray8 = dArray[2];
            if (Arrays.equals(dArray7, dArray8)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.seriesKeys.hashCode();
        n = 29 * n + this.seriesList.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultXYZDataset defaultXYZDataset = (DefaultXYZDataset)super.clone();
        defaultXYZDataset.seriesKeys = new ArrayList(this.seriesKeys);
        defaultXYZDataset.seriesList = new ArrayList(this.seriesList.size());
        for (int i = 0; i < this.seriesList.size(); ++i) {
            double[][] dArray = (double[][])this.seriesList.get(i);
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            double[] dArray5 = new double[dArray2.length];
            double[] dArray6 = new double[dArray3.length];
            double[] dArray7 = new double[dArray4.length];
            System.arraycopy(dArray2, 0, dArray5, 0, dArray2.length);
            System.arraycopy(dArray3, 0, dArray6, 0, dArray3.length);
            System.arraycopy(dArray4, 0, dArray7, 0, dArray4.length);
            defaultXYZDataset.seriesList.add(i, new double[][]{dArray5, dArray6, dArray7});
        }
        return defaultXYZDataset;
    }
}

