/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultIntervalXYDataset
extends AbstractIntervalXYDataset
implements PublicCloneable {
    private List seriesKeys = new ArrayList();
    private List seriesList = new ArrayList();

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public Comparable getSeriesKey(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (Comparable)this.seriesKeys.get(n);
    }

    public int getItemCount(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[0].length;
    }

    public double getXValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[0][n2];
    }

    public double getYValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[3][n2];
    }

    public double getStartXValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[1][n2];
    }

    public double getEndXValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[2][n2];
    }

    public double getStartYValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[4][n2];
    }

    public double getEndYValue(int n, int n2) {
        double[][] dArray = (double[][])this.seriesList.get(n);
        return dArray[5][n2];
    }

    public Number getEndX(int n, int n2) {
        return new Double(this.getEndXValue(n, n2));
    }

    public Number getEndY(int n, int n2) {
        return new Double(this.getEndYValue(n, n2));
    }

    public Number getStartX(int n, int n2) {
        return new Double(this.getStartXValue(n, n2));
    }

    public Number getStartY(int n, int n2) {
        return new Double(this.getStartYValue(n, n2));
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public void addSeries(Comparable comparable, double[][] dArray) {
        if (comparable == null) {
            throw new IllegalArgumentException("The 'seriesKey' cannot be null.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("The 'data' is null.");
        }
        if (dArray.length != 6) {
            throw new IllegalArgumentException("The 'data' array must have length == 6.");
        }
        int n = dArray[0].length;
        if (n != dArray[1].length || n != dArray[2].length || n != dArray[3].length || n != dArray[4].length || n != dArray[5].length) {
            throw new IllegalArgumentException("The 'data' array must contain six arrays with equal length.");
        }
        int n2 = this.indexOf(comparable);
        if (n2 == -1) {
            this.seriesKeys.add(comparable);
            this.seriesList.add(dArray);
        } else {
            this.seriesList.remove(n2);
            this.seriesList.add(n2, dArray);
        }
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultIntervalXYDataset)) {
            return false;
        }
        DefaultIntervalXYDataset defaultIntervalXYDataset = (DefaultIntervalXYDataset)object;
        if (!this.seriesKeys.equals(defaultIntervalXYDataset.seriesKeys)) {
            return false;
        }
        for (int i = 0; i < this.seriesList.size(); ++i) {
            double[][] dArray;
            double[] dArray2;
            double[][] dArray3 = (double[][])this.seriesList.get(i);
            double[] dArray4 = dArray3[0];
            if (!Arrays.equals(dArray4, dArray2 = (dArray = (double[][])defaultIntervalXYDataset.seriesList.get(i))[0])) {
                return false;
            }
            double[] dArray5 = dArray3[1];
            double[] dArray6 = dArray[1];
            if (!Arrays.equals(dArray5, dArray6)) {
                return false;
            }
            double[] dArray7 = dArray3[2];
            double[] dArray8 = dArray[2];
            if (!Arrays.equals(dArray7, dArray8)) {
                return false;
            }
            double[] dArray9 = dArray3[3];
            double[] dArray10 = dArray[3];
            if (!Arrays.equals(dArray9, dArray10)) {
                return false;
            }
            double[] dArray11 = dArray3[4];
            double[] dArray12 = dArray[4];
            if (!Arrays.equals(dArray11, dArray12)) {
                return false;
            }
            double[] dArray13 = dArray3[5];
            double[] dArray14 = dArray[5];
            if (Arrays.equals(dArray13, dArray14)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.seriesKeys.hashCode();
        n = 29 * n + this.seriesList.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultIntervalXYDataset defaultIntervalXYDataset = (DefaultIntervalXYDataset)super.clone();
        defaultIntervalXYDataset.seriesKeys = new ArrayList(this.seriesKeys);
        defaultIntervalXYDataset.seriesList = new ArrayList(this.seriesList.size());
        for (int i = 0; i < this.seriesList.size(); ++i) {
            double[][] dArray = (double[][])this.seriesList.get(i);
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            double[] dArray5 = dArray[3];
            double[] dArray6 = dArray[4];
            double[] dArray7 = dArray[5];
            double[] dArray8 = new double[dArray2.length];
            double[] dArray9 = new double[dArray3.length];
            double[] dArray10 = new double[dArray4.length];
            double[] dArray11 = new double[dArray5.length];
            double[] dArray12 = new double[dArray6.length];
            double[] dArray13 = new double[dArray7.length];
            System.arraycopy(dArray2, 0, dArray8, 0, dArray2.length);
            System.arraycopy(dArray3, 0, dArray9, 0, dArray3.length);
            System.arraycopy(dArray4, 0, dArray10, 0, dArray4.length);
            System.arraycopy(dArray5, 0, dArray11, 0, dArray5.length);
            System.arraycopy(dArray6, 0, dArray12, 0, dArray6.length);
            System.arraycopy(dArray7, 0, dArray13, 0, dArray7.length);
            defaultIntervalXYDataset.seriesList.add(i, new double[][]{dArray8, dArray9, dArray10, dArray11, dArray12, dArray13});
        }
        return defaultIntervalXYDataset;
    }
}

