/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xml;

import ai.org.jfree.data.xml.DatasetTags;
import ai.org.jfree.data.xml.ItemHandler;
import ai.org.jfree.data.xml.RootHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValueHandler
extends DefaultHandler
implements DatasetTags {
    private RootHandler rootHandler;
    private ItemHandler itemHandler;
    private StringBuffer currentText;

    public ValueHandler(RootHandler rootHandler, ItemHandler itemHandler) {
        this.rootHandler = rootHandler;
        this.itemHandler = itemHandler;
        this.currentText = new StringBuffer();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!string3.equals("Value")) {
            throw new SAXException("Expecting <Value> but found " + string3);
        }
        this.clearCurrentText();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Double d;
        if (string3.equals("Value")) {
            try {
                d = Double.valueOf(this.currentText.toString());
                if (d.isNaN()) {
                    d = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = null;
            }
        } else {
            throw new SAXException("Expecting </Value> but found " + string3);
        }
        this.itemHandler.setValue(d);
        this.rootHandler.popSubHandler();
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.currentText != null) {
            this.currentText.append(String.copyValueOf(cArray, n, n2));
        }
    }

    protected String getCurrentText() {
        return this.currentText.toString();
    }

    protected void clearCurrentText() {
        this.currentText.delete(0, this.currentText.length());
    }
}

