/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriodFormatException;
import ai.org.jfree.data.time.Year;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Week
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 1856387786939865061L;
    public static final int FIRST_WEEK_IN_YEAR = 1;
    public static final int LAST_WEEK_IN_YEAR = 53;
    private short year;
    private byte week;
    private long firstMillisecond;
    private long lastMillisecond;

    public Week() {
        this(new Date());
    }

    public Week(int n, int n2) {
        if (n < 1 && n > 53) {
            throw new IllegalArgumentException("The 'week' argument must be in the range 1 - 53.");
        }
        this.week = (byte)n;
        this.year = (short)n2;
        this.peg(Calendar.getInstance());
    }

    public Week(int n, Year year) {
        if (n < 1 && n > 53) {
            throw new IllegalArgumentException("The 'week' argument must be in the range 1 - 53.");
        }
        this.week = (byte)n;
        this.year = (short)year.getYear();
        this.peg(Calendar.getInstance());
    }

    public Week(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Week(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Week(Date date, TimeZone timeZone, Locale locale) {
        if (date == null) {
            throw new IllegalArgumentException("Null 'time' argument.");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Null 'locale' argument.");
        }
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        int n = calendar.get(3);
        if (n == 1 && calendar.get(2) == 11) {
            this.week = 1;
            this.year = (short)(calendar.get(1) + 1);
        } else {
            this.week = (byte)Math.min(n, 53);
            int n2 = calendar.get(1);
            if (calendar.get(2) == 0 && this.week >= 52) {
                --n2;
            }
            this.year = (short)n2;
        }
        this.peg(calendar);
    }

    public Year getYear() {
        return new Year(this.year);
    }

    public int getYearValue() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Week week;
        if (this.week != 1) {
            week = new Week(this.week - 1, this.year);
        } else if (this.year > 1900) {
            int n = this.year - 1;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, 11, 31);
            week = new Week(calendar.getActualMaximum(3), n);
        } else {
            week = null;
        }
        return week;
    }

    public RegularTimePeriod next() {
        Week week;
        if (this.week < 52) {
            week = new Week(this.week + 1, this.year);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year, 11, 31);
            int n = calendar.getActualMaximum(3);
            week = this.week < n ? new Week(this.week + 1, this.year) : (this.year < 9999 ? new Week(1, this.year + 1) : null);
        }
        return week;
    }

    public long getSerialIndex() {
        return (long)this.year * 53L + (long)this.week;
    }

    public long getFirstMillisecond(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.set(1, this.year);
        calendar2.set(3, this.week);
        calendar2.set(7, calendar2.getFirstDayOfWeek());
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return calendar2.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.set(1, this.year);
        calendar2.set(3, this.week + 1);
        calendar2.set(7, calendar2.getFirstDayOfWeek());
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return calendar2.getTime().getTime() - 1L;
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Week)) {
            return false;
        }
        Week week = (Week)object;
        if (this.week != week.week) {
            return false;
        }
        return this.year == week.year;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.week;
        n = 37 * n + this.year;
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Week) {
            Week week = (Week)object;
            n = this.year - week.getYear().getYear();
            if (n == 0) {
                n = this.week - week.getWeek();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String string) {
        Week week = null;
        if (string == null) return week;
        int n = Week.findSeparator(string = string.trim());
        if (n == -1) throw new TimePeriodFormatException("Could not find separator.");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, string.length()).trim();
        Year year = Week.evaluateAsYear(string2);
        if (year != null) {
            int n2 = Week.stringToWeek(string3);
            if (n2 != -1) return new Week(n2, year);
            throw new TimePeriodFormatException("Can't evaluate the week.");
        }
        year = Week.evaluateAsYear(string3);
        if (year == null) throw new TimePeriodFormatException("Can't evaluate the year.");
        int n3 = Week.stringToWeek(string2);
        if (n3 != -1) return new Week(n3, year);
        throw new TimePeriodFormatException("Can't evaluate the week.");
    }

    private static int findSeparator(String string) {
        int n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(46);
        }
        return n;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return year;
    }

    private static int stringToWeek(String string) {
        int n = -1;
        string = string.replace('W', ' ');
        string = string.trim();
        try {
            n = Integer.parseInt(string);
            if (n < 1 || n > 53) {
                n = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }
}

