/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.DefaultKeyedValues2D;
import ai.org.jfree.data.DomainInfo;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriod;
import ai.org.jfree.data.time.TimePeriodAnchor;
import ai.org.jfree.data.xy.AbstractIntervalXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.TableXYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class TimeTableXYDataset
extends AbstractIntervalXYDataset
implements Cloneable,
PublicCloneable,
IntervalXYDataset,
DomainInfo,
TableXYDataset {
    private DefaultKeyedValues2D values;
    private boolean domainIsPointsInTime;
    private TimePeriodAnchor xPosition;
    private Calendar workingCalendar;

    public TimeTableXYDataset() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public TimeTableXYDataset(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public TimeTableXYDataset(TimeZone timeZone, Locale locale) {
        if (timeZone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Null 'locale' argument.");
        }
        this.values = new DefaultKeyedValues2D(true);
        this.workingCalendar = Calendar.getInstance(timeZone, locale);
        this.xPosition = TimePeriodAnchor.START;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        if (timePeriodAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void add(TimePeriod timePeriod, double d, Comparable comparable) {
        this.add(timePeriod, new Double(d), comparable, true);
    }

    public void add(TimePeriod timePeriod, Number number, Comparable comparable, boolean bl) {
        if (timePeriod instanceof RegularTimePeriod) {
            RegularTimePeriod regularTimePeriod = (RegularTimePeriod)timePeriod;
            regularTimePeriod.peg(this.workingCalendar);
        }
        this.values.addValue(number, timePeriod, comparable);
        if (bl) {
            this.fireDatasetChanged();
        }
    }

    public void remove(TimePeriod timePeriod, Comparable comparable) {
        this.remove(timePeriod, comparable, true);
    }

    public void remove(TimePeriod timePeriod, Comparable comparable, boolean bl) {
        this.values.removeValue(timePeriod, comparable);
        if (bl) {
            this.fireDatasetChanged();
        }
    }

    public void clear() {
        if (this.values.getRowCount() > 0) {
            this.values.clear();
            this.fireDatasetChanged();
        }
    }

    public TimePeriod getTimePeriod(int n) {
        return (TimePeriod)this.values.getRowKey(n);
    }

    public int getItemCount() {
        return this.values.getRowCount();
    }

    public int getItemCount(int n) {
        return this.getItemCount();
    }

    public int getSeriesCount() {
        return this.values.getColumnCount();
    }

    public Comparable getSeriesKey(int n) {
        return this.values.getColumnKey(n);
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public double getXValue(int n, int n2) {
        TimePeriod timePeriod = (TimePeriod)this.values.getRowKey(n2);
        return this.getXValue(timePeriod);
    }

    public Number getStartX(int n, int n2) {
        return new Double(this.getStartXValue(n, n2));
    }

    public double getStartXValue(int n, int n2) {
        TimePeriod timePeriod = (TimePeriod)this.values.getRowKey(n2);
        return timePeriod.getStart().getTime();
    }

    public Number getEndX(int n, int n2) {
        return new Double(this.getEndXValue(n, n2));
    }

    public double getEndXValue(int n, int n2) {
        TimePeriod timePeriod = (TimePeriod)this.values.getRowKey(n2);
        return timePeriod.getEnd().getTime();
    }

    public Number getY(int n, int n2) {
        return this.values.getValue(n2, n);
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    private long getXValue(TimePeriod timePeriod) {
        long l = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l = timePeriod.getStart().getTime();
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            long l2 = timePeriod.getStart().getTime();
            long l3 = timePeriod.getEnd().getTime();
            l = l2 + (l3 - l2) / 2L;
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l = timePeriod.getEnd().getTime();
        }
        return l;
    }

    public double getDomainLowerBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getLowerBound();
        }
        return d;
    }

    public double getDomainUpperBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getUpperBound();
        }
        return d;
    }

    public Range getDomainBounds(boolean bl) {
        List list = this.values.getRowKeys();
        if (list.isEmpty()) {
            return null;
        }
        TimePeriod timePeriod = (TimePeriod)list.get(0);
        TimePeriod timePeriod2 = (TimePeriod)list.get(list.size() - 1);
        if (!bl || this.domainIsPointsInTime) {
            return new Range(this.getXValue(timePeriod), this.getXValue(timePeriod2));
        }
        return new Range(timePeriod.getStart().getTime(), timePeriod2.getEnd().getTime());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeTableXYDataset)) {
            return false;
        }
        TimeTableXYDataset timeTableXYDataset = (TimeTableXYDataset)object;
        if (this.domainIsPointsInTime != timeTableXYDataset.domainIsPointsInTime) {
            return false;
        }
        if (this.xPosition != timeTableXYDataset.xPosition) {
            return false;
        }
        if (!this.workingCalendar.getTimeZone().equals(timeTableXYDataset.workingCalendar.getTimeZone())) {
            return false;
        }
        return this.values.equals(timeTableXYDataset.values);
    }

    public Object clone() throws CloneNotSupportedException {
        TimeTableXYDataset timeTableXYDataset = (TimeTableXYDataset)super.clone();
        timeTableXYDataset.values = (DefaultKeyedValues2D)this.values.clone();
        timeTableXYDataset.workingCalendar = (Calendar)this.workingCalendar.clone();
        return timeTableXYDataset;
    }
}

