/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.general.Series;
import ai.org.jfree.data.general.SeriesException;
import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimeSeriesDataItem;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TimeSeries
extends Series
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5032960206869675528L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    protected List data;
    private int maximumItemCount;
    private long maximumItemAge;
    private double minY;
    private double maxY;

    public TimeSeries(Comparable comparable) {
        this(comparable, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimeSeries(Comparable comparable, String string, String string2) {
        super(comparable);
        this.domain = string;
        this.range = string2;
        this.timePeriodClass = null;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.maximumItemAge = Long.MAX_VALUE;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative 'maximum' argument.");
        }
        this.maximumItemCount = n;
        int n2 = this.data.size();
        if (n2 > n) {
            this.delete(0, n2 - n - 1);
        }
    }

    public long getMaximumItemAge() {
        return this.maximumItemAge;
    }

    public void setMaximumItemAge(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative 'periods' argument.");
        }
        this.maximumItemAge = l;
        this.removeAgedItems(true);
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataItem(int n) {
        TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(n);
        return (TimeSeriesDataItem)timeSeriesDataItem.clone();
    }

    public TimeSeriesDataItem getDataItem(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getDataItem(n);
        }
        return null;
    }

    TimeSeriesDataItem getRawDataItem(int n) {
        return (TimeSeriesDataItem)this.data.get(n);
    }

    TimeSeriesDataItem getRawDataItem(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return (TimeSeriesDataItem)this.data.get(n);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n) {
        return this.getRawDataItem(n).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            arrayList.add(this.getTimePeriod(i));
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(i);
            int n = this.getIndex(regularTimePeriod);
            if (n >= 0) continue;
            arrayList.add(regularTimePeriod);
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, -2.147483648E9);
        return Collections.binarySearch(this.data, timeSeriesDataItem);
    }

    public Number getValue(int n) {
        return this.getRawDataItem(n).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem) {
        this.add(timeSeriesDataItem, true);
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem, boolean bl) {
        Comparable comparable;
        if (timeSeriesDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem.clone();
        Class<?> clazz = timeSeriesDataItem.getPeriod().getClass();
        if (this.timePeriodClass == null) {
            this.timePeriodClass = clazz;
        } else if (!this.timePeriodClass.equals(clazz)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("You are trying to add data where the time period class ");
            stringBuffer.append("is ");
            stringBuffer.append(timeSeriesDataItem.getPeriod().getClass().getName());
            stringBuffer.append(", but the TimeSeries is expecting an instance of ");
            stringBuffer.append(this.timePeriodClass.getName());
            stringBuffer.append(".");
            throw new SeriesException(stringBuffer.toString());
        }
        boolean bl2 = false;
        int n = this.getItemCount();
        if (n == 0) {
            this.data.add(timeSeriesDataItem);
            bl2 = true;
        } else {
            comparable = this.getTimePeriod(this.getItemCount() - 1);
            if (timeSeriesDataItem.getPeriod().compareTo(comparable) > 0) {
                this.data.add(timeSeriesDataItem);
                bl2 = true;
            } else {
                int n2 = Collections.binarySearch(this.data, timeSeriesDataItem);
                if (n2 < 0) {
                    this.data.add(-n2 - 1, timeSeriesDataItem);
                    bl2 = true;
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("You are attempting to add an observation for ");
                    stringBuffer.append("the time period ");
                    stringBuffer.append(timeSeriesDataItem.getPeriod().toString());
                    stringBuffer.append(" but the series already contains an observation");
                    stringBuffer.append(" for that time period. Duplicates are not ");
                    stringBuffer.append("permitted.  Try using the addOrUpdate() method.");
                    throw new SeriesException(stringBuffer.toString());
                }
            }
        }
        if (bl2) {
            this.updateBoundsForAddedItem(timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                comparable = (TimeSeriesDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem((TimeSeriesDataItem)comparable);
            }
            this.removeAgedItems(false);
            if (bl) {
                this.fireSeriesChanged();
            }
        }
    }

    public void add(RegularTimePeriod regularTimePeriod, double d) {
        this.add(regularTimePeriod, d, true);
    }

    public void add(RegularTimePeriod regularTimePeriod, double d, boolean bl) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, d);
        this.add(timeSeriesDataItem, bl);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) {
        this.add(regularTimePeriod, number, true);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number, boolean bl) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        this.add(timeSeriesDataItem, bl);
    }

    public void update(RegularTimePeriod regularTimePeriod, double d) {
        this.update(regularTimePeriod, (Number)new Double(d));
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            throw new SeriesException("There is no existing value for the specified 'period'.");
        }
        this.update(n, number);
    }

    public void update(int n, Number number) {
        double d;
        TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(n);
        boolean bl = false;
        Number number2 = timeSeriesDataItem.getValue();
        if (number2 != null && !Double.isNaN(d = number2.doubleValue())) {
            bl = d <= this.minY || d >= this.maxY;
        }
        timeSeriesDataItem.setValue(number);
        if (bl) {
            this.findBoundsByIteration();
        } else if (number != null) {
            d = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d);
            this.maxY = this.maxIgnoreNaN(this.maxY, d);
        }
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries((Comparable)((Object)("Overwritten values from: " + this.getKey())));
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getRawDataItem(i);
            TimeSeriesDataItem timeSeriesDataItem2 = this.addOrUpdate(timeSeriesDataItem.getPeriod(), timeSeriesDataItem.getValue());
            if (timeSeriesDataItem2 == null) continue;
            timeSeries2.add(timeSeriesDataItem2);
        }
        return timeSeries2;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, double d) {
        return this.addOrUpdate(regularTimePeriod, new Double(d));
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        return this.addOrUpdate(new TimeSeriesDataItem(regularTimePeriod, number));
    }

    public TimeSeriesDataItem addOrUpdate(TimeSeriesDataItem timeSeriesDataItem) {
        if (timeSeriesDataItem == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        Class<?> clazz = timeSeriesDataItem.getPeriod().getClass();
        if (this.timePeriodClass == null) {
            this.timePeriodClass = clazz;
        } else if (!this.timePeriodClass.equals(clazz)) {
            String string = "You are trying to add data where the time period class is " + clazz.getName() + ", but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(string);
        }
        TimeSeriesDataItem timeSeriesDataItem2 = null;
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n >= 0) {
            double d;
            TimeSeriesDataItem timeSeriesDataItem3 = (TimeSeriesDataItem)this.data.get(n);
            timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem3.clone();
            boolean bl = false;
            Number number = timeSeriesDataItem3.getValue();
            double d2 = d = number != null ? number.doubleValue() : Double.NaN;
            if (!Double.isNaN(d)) {
                bl = d <= this.minY || d >= this.maxY;
            }
            timeSeriesDataItem3.setValue(timeSeriesDataItem.getValue());
            if (bl) {
                this.findBoundsByIteration();
            } else if (timeSeriesDataItem.getValue() != null) {
                double d3 = timeSeriesDataItem.getValue().doubleValue();
                this.minY = this.minIgnoreNaN(this.minY, d3);
                this.maxY = this.minIgnoreNaN(this.maxY, d3);
            }
        } else {
            timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem.clone();
            this.data.add(-n - 1, timeSeriesDataItem);
            this.updateBoundsForAddedItem(timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                TimeSeriesDataItem timeSeriesDataItem4 = (TimeSeriesDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem(timeSeriesDataItem4);
            }
        }
        this.removeAgedItems(false);
        this.fireSeriesChanged();
        return timeSeriesDataItem2;
    }

    public void removeAgedItems(boolean bl) {
        if (this.getItemCount() > 1) {
            long l = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
            boolean bl2 = false;
            while (l - this.getTimePeriod(0).getSerialIndex() > this.maximumItemAge) {
                this.data.remove(0);
                bl2 = true;
            }
            if (bl2) {
                this.findBoundsByIteration();
                if (bl) {
                    this.fireSeriesChanged();
                }
            }
        }
    }

    public void removeAgedItems(long l, boolean bl) {
        if (this.data.isEmpty()) {
            return;
        }
        long l2 = Long.MAX_VALUE;
        try {
            Method method = RegularTimePeriod.class.getDeclaredMethod("createInstance", Class.class, Date.class, TimeZone.class);
            RegularTimePeriod regularTimePeriod = (RegularTimePeriod)method.invoke((Object)this.timePeriodClass, this.timePeriodClass, new Date(l), TimeZone.getDefault());
            l2 = regularTimePeriod.getSerialIndex();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        boolean bl2 = false;
        while (this.getItemCount() > 0 && l2 - this.getTimePeriod(0).getSerialIndex() > this.maximumItemAge) {
            this.data.remove(0);
            bl2 = true;
        }
        if (bl2) {
            this.findBoundsByIteration();
            if (bl) {
                this.fireSeriesChanged();
            }
        }
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.timePeriodClass = null;
            this.minY = Double.NaN;
            this.maxY = Double.NaN;
            this.fireSeriesChanged();
        }
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.remove(n);
            this.updateBoundsForRemovedItem(timeSeriesDataItem);
            if (this.data.isEmpty()) {
                this.timePeriodClass = null;
            }
            this.fireSeriesChanged();
        }
    }

    public void delete(int n, int n2) {
        this.delete(n, n2, true);
    }

    public void delete(int n, int n2, boolean bl) {
        if (n2 < n) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        for (int i = 0; i <= n2 - n; ++i) {
            this.data.remove(n);
        }
        this.findBoundsByIteration();
        if (this.data.isEmpty()) {
            this.timePeriodClass = null;
        }
        if (bl) {
            this.fireSeriesChanged();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = (List)ObjectUtilities.deepClone(this.data);
        return timeSeries;
    }

    public TimeSeries createCopy(int n, int n2) throws CloneNotSupportedException {
        if (n < 0) {
            throw new IllegalArgumentException("Requires start >= 0.");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.minY = Double.NaN;
        timeSeries.maxY = Double.NaN;
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(i);
                TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem.clone();
                try {
                    timeSeries.add(timeSeriesDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    seriesException.printStackTrace();
                }
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) throws CloneNotSupportedException {
        int n;
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'start' argument.");
        }
        if (regularTimePeriod2 == null) {
            throw new IllegalArgumentException("Null 'end' argument.");
        }
        if (regularTimePeriod.compareTo(regularTimePeriod2) > 0) {
            throw new IllegalArgumentException("Requires start on or before end.");
        }
        boolean bl = false;
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 < 0 && (n2 = -(n2 + 1)) == this.data.size()) {
            bl = true;
        }
        if ((n = this.getIndex(regularTimePeriod2)) < 0) {
            n = -(n + 1);
            --n;
        }
        if (n < 0 || n < n2) {
            bl = true;
        }
        if (bl) {
            TimeSeries timeSeries = (TimeSeries)super.clone();
            timeSeries.data = new ArrayList();
            return timeSeries;
        }
        return this.createCopy(n2, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeries)) {
            return false;
        }
        TimeSeries timeSeries = (TimeSeries)object;
        if (!ObjectUtilities.equal(this.getDomainDescription(), timeSeries.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getRangeDescription(), timeSeries.getRangeDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.timePeriodClass, timeSeries.timePeriodClass)) {
            return false;
        }
        if (this.getMaximumItemAge() != timeSeries.getMaximumItemAge()) {
            return false;
        }
        if (this.getMaximumItemCount() != timeSeries.getMaximumItemCount()) {
            return false;
        }
        int n = this.getItemCount();
        if (n != timeSeries.getItemCount()) {
            return false;
        }
        if (!ObjectUtilities.equal(this.data, timeSeries.data)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        TimeSeriesDataItem timeSeriesDataItem;
        int n = super.hashCode();
        n = 29 * n + (this.domain != null ? this.domain.hashCode() : 0);
        n = 29 * n + (this.range != null ? this.range.hashCode() : 0);
        n = 29 * n + (this.timePeriodClass != null ? this.timePeriodClass.hashCode() : 0);
        int n2 = this.getItemCount();
        if (n2 > 0) {
            timeSeriesDataItem = this.getRawDataItem(0);
            n = 29 * n + timeSeriesDataItem.hashCode();
        }
        if (n2 > 1) {
            timeSeriesDataItem = this.getRawDataItem(n2 - 1);
            n = 29 * n + timeSeriesDataItem.hashCode();
        }
        if (n2 > 2) {
            timeSeriesDataItem = this.getRawDataItem(n2 / 2);
            n = 29 * n + timeSeriesDataItem.hashCode();
        }
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + (int)this.maximumItemAge;
        return n;
    }

    private void updateBoundsForAddedItem(TimeSeriesDataItem timeSeriesDataItem) {
        Number number = timeSeriesDataItem.getValue();
        if (timeSeriesDataItem.getValue() != null) {
            double d = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d);
            this.maxY = this.maxIgnoreNaN(this.maxY, d);
        }
    }

    private void updateBoundsForRemovedItem(TimeSeriesDataItem timeSeriesDataItem) {
        double d;
        Number number = timeSeriesDataItem.getValue();
        if (number != null && !Double.isNaN(d = number.doubleValue()) && (d <= this.minY || d >= this.maxY)) {
            this.findBoundsByIteration();
        }
    }

    private void findBoundsByIteration() {
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        for (TimeSeriesDataItem timeSeriesDataItem : this.data) {
            this.updateBoundsForAddedItem(timeSeriesDataItem);
        }
    }

    private double minIgnoreNaN(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.min(d, d2);
    }

    private double maxIgnoreNaN(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.max(d, d2);
    }

    public TimeSeries(Comparable comparable, Class clazz) {
        this(comparable, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(Comparable comparable, String string, String string2, Class clazz) {
        super(comparable);
        this.domain = string;
        this.range = string2;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.maximumItemAge = Long.MAX_VALUE;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }
}

