/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.Day;
import ai.org.jfree.data.time.Hour;
import ai.org.jfree.data.time.Minute;
import ai.org.jfree.data.time.RegularTimePeriod;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Second
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -6536564190712383466L;
    public static final int FIRST_SECOND_IN_MINUTE = 0;
    public static final int LAST_SECOND_IN_MINUTE = 59;
    private Day day;
    private byte hour;
    private byte minute;
    private byte second;
    private long firstMillisecond;

    public Second() {
        this(new Date());
    }

    public Second(int n, Minute minute) {
        if (minute == null) {
            throw new IllegalArgumentException("Null 'minute' argument.");
        }
        this.day = minute.getDay();
        this.hour = (byte)minute.getHourValue();
        this.minute = (byte)minute.getMinute();
        this.second = (byte)n;
        this.peg(Calendar.getInstance());
    }

    public Second(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, new Minute(n2, n3, n4, n5, n6));
    }

    public Second(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Second(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Second(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.second = (byte)calendar.get(13);
        this.minute = (byte)calendar.get(12);
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone, locale);
        this.peg(calendar);
    }

    public int getSecond() {
        return this.second;
    }

    public Minute getMinute() {
        return new Minute(this.minute, new Hour(this.hour, this.day));
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.firstMillisecond + 999L;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Second second = null;
        if (this.second != 0) {
            second = new Second(this.second - 1, this.getMinute());
        } else {
            Minute minute = (Minute)this.getMinute().previous();
            if (minute != null) {
                second = new Second(59, minute);
            }
        }
        return second;
    }

    public RegularTimePeriod next() {
        Second second = null;
        if (this.second != 59) {
            second = new Second(this.second + 1, this.getMinute());
        } else {
            Minute minute = (Minute)this.getMinute().next();
            if (minute != null) {
                second = new Second(0, minute);
            }
        }
        return second;
    }

    public long getSerialIndex() {
        long l = this.day.getSerialIndex() * 24L + (long)this.hour;
        long l2 = l * 60L + (long)this.minute;
        return l2 * 60L + (long)this.second;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour, this.minute, this.second);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        return this.getFirstMillisecond(calendar) + 999L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Second)) {
            return false;
        }
        Second second = (Second)object;
        if (this.second != second.second) {
            return false;
        }
        if (this.minute != second.minute) {
            return false;
        }
        if (this.hour != second.hour) {
            return false;
        }
        return this.day.equals(second.day);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.second;
        n = 37 * n + this.minute;
        n = 37 * n + this.hour;
        n = 37 * n + this.day.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        if (object instanceof Second) {
            Second second = (Second)object;
            if (this.firstMillisecond < second.firstMillisecond) {
                return -1;
            }
            if (this.firstMillisecond > second.firstMillisecond) {
                return 1;
            }
            return 0;
        }
        int n = object instanceof RegularTimePeriod ? 0 : 1;
        return n;
    }

    public static Second parseSecond(String string) {
        Second second = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            int n;
            String string3 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            string3 = string3.trim();
            int n2 = string3.length();
            String string4 = string3.substring(0, Math.min(2, n2));
            String string5 = string3.substring(Math.min(3, n2), Math.min(5, n2));
            String string6 = string3.substring(Math.min(6, n2), Math.min(8, n2));
            int n3 = Integer.parseInt(string4);
            if (n3 >= 0 && n3 <= 23 && (n = Integer.parseInt(string5)) >= 0 && n <= 59) {
                Minute minute = new Minute(n, new Hour(n3, day));
                int n4 = Integer.parseInt(string6);
                if (n4 >= 0 && n4 <= 59) {
                    second = new Second(n4, minute);
                }
            }
        }
        return second;
    }
}

