/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriodFormatException;
import ai.org.jfree.data.time.Year;
import ai.org.jfree.date.SerialDate;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Month
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -5090216912548722570L;
    private int month;
    private int year;
    private long firstMillisecond;
    private long lastMillisecond;

    public Month() {
        this(new Date());
    }

    public Month(int n, int n2) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month outside valid range.");
        }
        this.month = n;
        this.year = n2;
        this.peg(Calendar.getInstance());
    }

    public Month(int n, Year year) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month outside valid range.");
        }
        this.month = n;
        this.year = year.getYear();
        this.peg(Calendar.getInstance());
    }

    public Month(Date date) {
        this(date, TimeZone.getDefault());
    }

    public Month(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Month(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
        this.peg(calendar);
    }

    public Year getYear() {
        return new Year(this.year);
    }

    public int getYearValue() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Month month = this.month != 1 ? new Month(this.month - 1, this.year) : (this.year > 1900 ? new Month(12, this.year - 1) : null);
        return month;
    }

    public RegularTimePeriod next() {
        Month month = this.month != 12 ? new Month(this.month + 1, this.year) : (this.year < 9999 ? new Month(1, this.year + 1) : null);
        return month;
    }

    public long getSerialIndex() {
        return (long)this.year * 12L + (long)this.month;
    }

    public String toString() {
        return SerialDate.monthCodeToString(this.month) + " " + this.year;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Month)) {
            return false;
        }
        Month month = (Month)object;
        if (this.month != month.month) {
            return false;
        }
        return this.year == month.year;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.month;
        n = 37 * n + this.year;
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Month) {
            Month month = (Month)object;
            n = this.year - month.getYearValue();
            if (n == 0) {
                n = this.month - month.getMonth();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getFirstMillisecond(Calendar calendar) {
        calendar.set(this.year, this.month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = SerialDate.lastDayOfMonth(this.month, this.year);
        calendar.set(this.year, this.month - 1, n, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Month parseMonth(String string) {
        int n;
        Year year;
        String string2;
        String string3;
        boolean bl;
        Month month = null;
        if (string == null) {
            return month;
        }
        int n2 = Month.findSeparator(string = string.trim());
        if (n2 == -1) {
            bl = true;
            string3 = string.substring(0, 5);
            string2 = string.substring(5);
        } else {
            string3 = string.substring(0, n2).trim();
            string2 = string.substring(n2 + 1, string.length()).trim();
            year = Month.evaluateAsYear(string3);
            if (year == null) {
                bl = false;
            } else {
                Year year2 = Month.evaluateAsYear(string2);
                if (year2 == null) {
                    bl = true;
                } else {
                    boolean bl2 = bl = string3.length() > string2.length();
                }
            }
        }
        if (bl) {
            year = Month.evaluateAsYear(string3);
            n = SerialDate.stringToMonthCode(string2);
        } else {
            year = Month.evaluateAsYear(string2);
            n = SerialDate.stringToMonthCode(string3);
        }
        if (n == -1) {
            throw new TimePeriodFormatException("Can't evaluate the month.");
        }
        if (year == null) {
            throw new TimePeriodFormatException("Can't evaluate the year.");
        }
        month = new Month(n, year);
        return month;
    }

    private static int findSeparator(String string) {
        int n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(46);
        }
        return n;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return year;
    }
}

