/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.Day;
import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.Second;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Millisecond
extends RegularTimePeriod
implements Serializable {
    static final long serialVersionUID = -5316836467277638485L;
    public static final int FIRST_MILLISECOND_IN_SECOND = 0;
    public static final int LAST_MILLISECOND_IN_SECOND = 999;
    private Day day;
    private byte hour;
    private byte minute;
    private byte second;
    private int millisecond;
    private long firstMillisecond;

    public Millisecond() {
        this(new Date());
    }

    public Millisecond(int n, Second second) {
        this.millisecond = n;
        this.second = (byte)second.getSecond();
        this.minute = (byte)second.getMinute().getMinute();
        this.hour = (byte)second.getMinute().getHourValue();
        this.day = second.getMinute().getDay();
        this.peg(Calendar.getInstance());
    }

    public Millisecond(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, new Second(n2, n3, n4, n5, n6, n7));
    }

    public Millisecond(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Millisecond(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Millisecond(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.millisecond = calendar.get(14);
        this.second = (byte)calendar.get(13);
        this.minute = (byte)calendar.get(12);
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone, locale);
        this.peg(calendar);
    }

    public Second getSecond() {
        return new Second(this.second, this.minute, this.hour, this.day.getDayOfMonth(), this.day.getMonth(), this.day.getYear());
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.firstMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Millisecond millisecond = null;
        if (this.millisecond != 0) {
            millisecond = new Millisecond(this.millisecond - 1, this.getSecond());
        } else {
            Second second = (Second)this.getSecond().previous();
            if (second != null) {
                millisecond = new Millisecond(999, second);
            }
        }
        return millisecond;
    }

    public RegularTimePeriod next() {
        Millisecond millisecond = null;
        if (this.millisecond != 999) {
            millisecond = new Millisecond(this.millisecond + 1, this.getSecond());
        } else {
            Second second = (Second)this.getSecond().next();
            if (second != null) {
                millisecond = new Millisecond(0, second);
            }
        }
        return millisecond;
    }

    public long getSerialIndex() {
        long l = this.day.getSerialIndex() * 24L + (long)this.hour;
        long l2 = l * 60L + (long)this.minute;
        long l3 = l2 * 60L + (long)this.second;
        return l3 * 1000L + (long)this.millisecond;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Millisecond)) {
            return false;
        }
        Millisecond millisecond = (Millisecond)object;
        if (this.millisecond != millisecond.millisecond) {
            return false;
        }
        if (this.second != millisecond.second) {
            return false;
        }
        if (this.minute != millisecond.minute) {
            return false;
        }
        if (this.hour != millisecond.hour) {
            return false;
        }
        return this.day.equals(millisecond.day);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.millisecond;
        n = 37 * n + this.getSecond().hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            long l = this.getFirstMillisecond() - millisecond.getFirstMillisecond();
            n = l > 0L ? 1 : (l < 0L ? -1 : 0);
        } else if (object instanceof RegularTimePeriod) {
            long l;
            RegularTimePeriod regularTimePeriod = (RegularTimePeriod)object;
            long l2 = this.getFirstMillisecond();
            n = l2 < (l = regularTimePeriod.getFirstMillisecond()) ? -1 : (l2 == l ? 0 : 1);
        } else {
            n = 1;
        }
        return n;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = this.day.getYear();
        int n2 = this.day.getMonth() - 1;
        int n3 = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour, this.minute, this.second);
        calendar.set(14, this.millisecond);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        return this.getFirstMillisecond(calendar);
    }
}

