/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.Range;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class DateRange
extends Range
implements Serializable {
    private static final long serialVersionUID = -4705682568375418157L;
    private long lowerDate;
    private long upperDate;

    public DateRange() {
        this(new Date(0L), new Date(1L));
    }

    public DateRange(Date date, Date date2) {
        super(date.getTime(), date2.getTime());
        this.lowerDate = date.getTime();
        this.upperDate = date2.getTime();
    }

    public DateRange(double d, double d2) {
        super(d, d2);
        this.lowerDate = (long)d;
        this.upperDate = (long)d2;
    }

    public DateRange(Range range) {
        this(range.getLowerBound(), range.getUpperBound());
    }

    public Date getLowerDate() {
        return new Date(this.lowerDate);
    }

    public long getLowerMillis() {
        return this.lowerDate;
    }

    public Date getUpperDate() {
        return new Date(this.upperDate);
    }

    public long getUpperMillis() {
        return this.upperDate;
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return "[" + dateFormat.format(this.getLowerDate()) + " --> " + dateFormat.format(this.getUpperDate()) + "]";
    }
}

