/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.statistics;

import ai.org.jfree.data.KeyedObjects2D;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.RangeInfo;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.statistics.MultiValueCategoryDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DefaultMultiValueCategoryDataset
extends AbstractDataset
implements MultiValueCategoryDataset,
RangeInfo,
PublicCloneable {
    protected KeyedObjects2D data = new KeyedObjects2D();
    private Number minimumRangeValue = null;
    private Number maximumRangeValue = null;
    private Range rangeBounds = new Range(0.0, 0.0);

    public void add(List list, Comparable comparable, Comparable comparable2) {
        double d;
        if (list == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (comparable2 == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        ArrayList<Number> arrayList = new ArrayList<Number>(list.size());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Number number;
            Object e = listIterator.next();
            if (!(e instanceof Number) || Double.isNaN(d = (number = (Number)e).doubleValue())) continue;
            arrayList.add(number);
        }
        Collections.sort(arrayList);
        this.data.addObject(arrayList, comparable, comparable2);
        if (arrayList.size() > 0) {
            double d2 = Double.NEGATIVE_INFINITY;
            d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < arrayList.size(); ++i) {
                Number number = (Number)arrayList.get(i);
                double d3 = number.doubleValue();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (this.maximumRangeValue == null) {
                this.maximumRangeValue = new Double(d2);
            } else if (d2 > this.maximumRangeValue.doubleValue()) {
                this.maximumRangeValue = new Double(d2);
            }
            if (this.minimumRangeValue == null) {
                this.minimumRangeValue = new Double(d);
            } else if (d < this.minimumRangeValue.doubleValue()) {
                this.minimumRangeValue = new Double(d);
            }
            this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        this.fireDatasetChanged();
    }

    public List getValues(int n, int n2) {
        List list = (List)this.data.getObject(n, n2);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.EMPTY_LIST;
    }

    public List getValues(Comparable comparable, Comparable comparable2) {
        return Collections.unmodifiableList((List)this.data.getObject(comparable, comparable2));
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        List list = (List)this.data.getObject(comparable, comparable2);
        double d = 0.0;
        int n = 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                d += number.doubleValue();
                ++n;
            }
            if (n > 0) {
                d /= (double)n;
            }
        }
        if (n == 0) {
            return null;
        }
        return new Double(d);
    }

    public Number getValue(int n, int n2) {
        List list = (List)this.data.getObject(n, n2);
        double d = 0.0;
        int n3 = 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                d += number.doubleValue();
                ++n3;
            }
            if (n3 > 0) {
                d /= (double)n3;
            }
        }
        if (n3 == 0) {
            return null;
        }
        return new Double(d);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        if (this.minimumRangeValue != null) {
            d = this.minimumRangeValue.doubleValue();
        }
        return d;
    }

    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        if (this.maximumRangeValue != null) {
            d = this.maximumRangeValue.doubleValue();
        }
        return d;
    }

    public Range getRangeBounds(boolean bl) {
        return this.rangeBounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultMultiValueCategoryDataset)) {
            return false;
        }
        DefaultMultiValueCategoryDataset defaultMultiValueCategoryDataset = (DefaultMultiValueCategoryDataset)object;
        return this.data.equals(defaultMultiValueCategoryDataset.data);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultMultiValueCategoryDataset defaultMultiValueCategoryDataset = (DefaultMultiValueCategoryDataset)super.clone();
        defaultMultiValueCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultMultiValueCategoryDataset;
    }
}

