/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.statistics;

import ai.org.jfree.data.Range;
import ai.org.jfree.data.RangeInfo;
import ai.org.jfree.data.statistics.BoxAndWhiskerItem;
import ai.org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import ai.org.jfree.data.xy.AbstractXYDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DefaultBoxAndWhiskerXYDataset
extends AbstractXYDataset
implements BoxAndWhiskerXYDataset,
RangeInfo {
    private Comparable seriesKey;
    private List dates;
    private List items;
    private Number minimumRangeValue;
    private Number maximumRangeValue;
    private Range rangeBounds;
    private double outlierCoefficient = 1.5;
    private double faroutCoefficient = 2.0;

    public DefaultBoxAndWhiskerXYDataset(Comparable comparable) {
        this.seriesKey = comparable;
        this.dates = new ArrayList();
        this.items = new ArrayList();
        this.minimumRangeValue = null;
        this.maximumRangeValue = null;
        this.rangeBounds = null;
    }

    public double getOutlierCoefficient() {
        return this.outlierCoefficient;
    }

    public void setOutlierCoefficient(double d) {
        this.outlierCoefficient = d;
    }

    public double getFaroutCoefficient() {
        return this.faroutCoefficient;
    }

    public void setFaroutCoefficient(double d) {
        if (!(d > this.getOutlierCoefficient())) {
            throw new IllegalArgumentException("Farout value must be greater than the outlier value, which is currently set at: (" + this.getOutlierCoefficient() + ")");
        }
        this.faroutCoefficient = d;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int n) {
        return this.dates.size();
    }

    public void add(Date date, BoxAndWhiskerItem boxAndWhiskerItem) {
        this.dates.add(date);
        this.items.add(boxAndWhiskerItem);
        if (this.minimumRangeValue == null) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        } else if (boxAndWhiskerItem.getMinRegularValue().doubleValue() < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        }
        if (this.maximumRangeValue == null) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        } else if (boxAndWhiskerItem.getMaxRegularValue().doubleValue() > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        }
        this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        this.fireDatasetChanged();
    }

    public Comparable getSeriesKey(int n) {
        return this.seriesKey;
    }

    public BoxAndWhiskerItem getItem(int n, int n2) {
        return (BoxAndWhiskerItem)this.items.get(n2);
    }

    public Number getX(int n, int n2) {
        return new Long(((Date)this.dates.get(n2)).getTime());
    }

    public Date getXDate(int n, int n2) {
        return (Date)this.dates.get(n2);
    }

    public Number getY(int n, int n2) {
        return this.getMeanValue(n, n2);
    }

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMedianValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getQ1Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ3Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public Number getMinRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMinOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public List getOutliers(int n, int n2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        if (this.minimumRangeValue != null) {
            d = this.minimumRangeValue.doubleValue();
        }
        return d;
    }

    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        if (this.maximumRangeValue != null) {
            d = this.maximumRangeValue.doubleValue();
        }
        return d;
    }

    public Range getRangeBounds(boolean bl) {
        return this.rangeBounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultBoxAndWhiskerXYDataset)) {
            return false;
        }
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = (DefaultBoxAndWhiskerXYDataset)object;
        if (!ObjectUtilities.equal(this.seriesKey, defaultBoxAndWhiskerXYDataset.seriesKey)) {
            return false;
        }
        if (!this.dates.equals(defaultBoxAndWhiskerXYDataset.dates)) {
            return false;
        }
        return this.items.equals(defaultBoxAndWhiskerXYDataset.items);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = (DefaultBoxAndWhiskerXYDataset)super.clone();
        defaultBoxAndWhiskerXYDataset.dates = new ArrayList(this.dates);
        defaultBoxAndWhiskerXYDataset.items = new ArrayList(this.items);
        return defaultBoxAndWhiskerXYDataset;
    }
}

