/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.statistics;

import ai.org.jfree.data.KeyedObjects2D;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.RangeInfo;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.statistics.BoxAndWhiskerCalculator;
import ai.org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import ai.org.jfree.data.statistics.BoxAndWhiskerItem;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.util.List;

public class DefaultBoxAndWhiskerCategoryDataset
extends AbstractDataset
implements BoxAndWhiskerCategoryDataset,
RangeInfo,
PublicCloneable {
    protected KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private int minimumRangeValueRow = -1;
    private int minimumRangeValueColumn = -1;
    private double maximumRangeValue = Double.NaN;
    private int maximumRangeValueRow = -1;
    private int maximumRangeValueColumn = -1;

    public void add(List list, Comparable comparable, Comparable comparable2) {
        BoxAndWhiskerItem boxAndWhiskerItem = BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(list);
        this.add(boxAndWhiskerItem, comparable, comparable2);
    }

    public void add(BoxAndWhiskerItem boxAndWhiskerItem, Comparable comparable, Comparable comparable2) {
        this.data.addObject(boxAndWhiskerItem, comparable, comparable2);
        int n = this.data.getRowIndex(comparable);
        int n2 = this.data.getColumnIndex(comparable2);
        if (this.maximumRangeValueRow == n && this.maximumRangeValueColumn == n2 || this.minimumRangeValueRow == n && this.minimumRangeValueColumn == n2) {
            this.updateBounds();
        } else {
            double d = Double.NaN;
            if (boxAndWhiskerItem.getMinOutlier() != null) {
                d = boxAndWhiskerItem.getMinOutlier().doubleValue();
            }
            double d2 = Double.NaN;
            if (boxAndWhiskerItem.getMaxOutlier() != null) {
                d2 = boxAndWhiskerItem.getMaxOutlier().doubleValue();
            }
            if (Double.isNaN(this.maximumRangeValue)) {
                this.maximumRangeValue = d2;
                this.maximumRangeValueRow = n;
                this.maximumRangeValueColumn = n2;
            } else if (d2 > this.maximumRangeValue) {
                this.maximumRangeValue = d2;
                this.maximumRangeValueRow = n;
                this.maximumRangeValueColumn = n2;
            }
            if (Double.isNaN(this.minimumRangeValue)) {
                this.minimumRangeValue = d;
                this.minimumRangeValueRow = n;
                this.minimumRangeValueColumn = n2;
            } else if (d < this.minimumRangeValue) {
                this.minimumRangeValue = d;
                this.minimumRangeValueRow = n;
                this.minimumRangeValueColumn = n2;
            }
        }
        this.fireDatasetChanged();
    }

    public void remove(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        this.data.removeObject(comparable, comparable2);
        if (this.maximumRangeValueRow == n && this.maximumRangeValueColumn == n2 || this.minimumRangeValueRow == n && this.minimumRangeValueColumn == n2) {
            this.updateBounds();
        }
        this.fireDatasetChanged();
    }

    public void removeRow(int n) {
        this.data.removeRow(n);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable comparable) {
        this.data.removeRow(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(int n) {
        this.data.removeColumn(n);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable comparable) {
        this.data.removeColumn(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public BoxAndWhiskerItem getItem(int n, int n2) {
        return (BoxAndWhiskerItem)this.data.getObject(n, n2);
    }

    public Number getValue(int n, int n2) {
        return this.getMedianValue(n, n2);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMedianValue(comparable, comparable2);
    }

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMedianValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getMedianValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getQ1Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ1Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ3Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public Number getQ3Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public double getRangeLowerBound(boolean bl) {
        return this.minimumRangeValue;
    }

    public double getRangeUpperBound(boolean bl) {
        return this.maximumRangeValue;
    }

    public Range getRangeBounds(boolean bl) {
        return new Range(this.minimumRangeValue, this.maximumRangeValue);
    }

    public Number getMinRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMinRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMinOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMinOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public List getOutliers(int n, int n2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    public List getOutliers(Comparable comparable, Comparable comparable2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    private void updateBounds() {
        this.minimumRangeValue = Double.NaN;
        this.minimumRangeValueRow = -1;
        this.minimumRangeValueColumn = -1;
        this.maximumRangeValue = Double.NaN;
        this.maximumRangeValueRow = -1;
        this.maximumRangeValueColumn = -1;
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d;
                Number number;
                double d2;
                BoxAndWhiskerItem boxAndWhiskerItem = this.getItem(i, j);
                if (boxAndWhiskerItem == null) continue;
                Number number2 = boxAndWhiskerItem.getMinOutlier();
                if (number2 != null && !Double.isNaN(d2 = number2.doubleValue()) && (d2 < this.minimumRangeValue || Double.isNaN(this.minimumRangeValue))) {
                    this.minimumRangeValue = d2;
                    this.minimumRangeValueRow = i;
                    this.minimumRangeValueColumn = j;
                }
                if ((number = boxAndWhiskerItem.getMaxOutlier()) == null || Double.isNaN(d = number.doubleValue()) || !(d > this.maximumRangeValue) && !Double.isNaN(this.maximumRangeValue)) continue;
                this.maximumRangeValue = d;
                this.maximumRangeValueRow = i;
                this.maximumRangeValueColumn = j;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultBoxAndWhiskerCategoryDataset) {
            DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)object;
            return ObjectUtilities.equal(this.data, defaultBoxAndWhiskerCategoryDataset.data);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)super.clone();
        defaultBoxAndWhiskerCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultBoxAndWhiskerCategoryDataset;
    }
}

