/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.general;

import ai.org.jfree.data.DefaultKeyedValue;
import ai.org.jfree.data.KeyedValue;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.KeyedValueDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;

public class DefaultKeyedValueDataset
extends AbstractDataset
implements KeyedValueDataset,
Serializable {
    private static final long serialVersionUID = -8149484339560406750L;
    private KeyedValue data;

    public DefaultKeyedValueDataset() {
        this(null);
    }

    public DefaultKeyedValueDataset(Comparable comparable, Number number) {
        this(new DefaultKeyedValue(comparable, number));
    }

    public DefaultKeyedValueDataset(KeyedValue keyedValue) {
        this.data = keyedValue;
    }

    public Comparable getKey() {
        Comparable comparable = null;
        if (this.data != null) {
            comparable = this.data.getKey();
        }
        return comparable;
    }

    public Number getValue() {
        Number number = null;
        if (this.data != null) {
            number = this.data.getValue();
        }
        return number;
    }

    public void updateValue(Number number) {
        if (this.data == null) {
            throw new RuntimeException("updateValue: can't update null.");
        }
        this.setValue(this.data.getKey(), number);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data = new DefaultKeyedValue(comparable, number);
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValueDataset)) {
            return false;
        }
        KeyedValueDataset keyedValueDataset = (KeyedValueDataset)object;
        if (this.data == null) {
            return keyedValueDataset.getKey() == null && keyedValueDataset.getValue() == null;
        }
        if (!ObjectUtilities.equal(this.data.getKey(), keyedValueDataset.getKey())) {
            return false;
        }
        return ObjectUtilities.equal(this.data.getValue(), keyedValueDataset.getValue());
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValueDataset defaultKeyedValueDataset = (DefaultKeyedValueDataset)super.clone();
        return defaultKeyedValueDataset;
    }
}

