/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.gantt;

import ai.org.jfree.data.gantt.Task;
import ai.org.jfree.data.gantt.TaskSeries;
import ai.org.jfree.data.gantt.TaskSeriesCollection;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.time.TimePeriod;
import ai.org.jfree.data.xy.AbstractXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import java.util.Date;

public class XYTaskDataset
extends AbstractXYDataset
implements IntervalXYDataset,
DatasetChangeListener {
    private TaskSeriesCollection underlying;
    private double seriesWidth;
    private boolean transposed;

    public XYTaskDataset(TaskSeriesCollection taskSeriesCollection) {
        if (taskSeriesCollection == null) {
            throw new IllegalArgumentException("Null 'tasks' argument.");
        }
        this.underlying = taskSeriesCollection;
        this.seriesWidth = 0.8;
        this.underlying.addChangeListener(this);
    }

    public TaskSeriesCollection getTasks() {
        return this.underlying;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public void setSeriesWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires 'w' > 0.0.");
        }
        this.seriesWidth = d;
        this.fireDatasetChanged();
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setTransposed(boolean bl) {
        this.transposed = bl;
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    public Comparable getSeriesKey(int n) {
        return this.underlying.getSeriesKey(n);
    }

    public int getItemCount(int n) {
        return this.underlying.getSeries(n).getItemCount();
    }

    public double getXValue(int n, int n2) {
        if (!this.transposed) {
            return this.getSeriesValue(n);
        }
        return this.getItemValue(n, n2);
    }

    public double getStartXValue(int n, int n2) {
        if (!this.transposed) {
            return this.getSeriesStartValue(n);
        }
        return this.getItemStartValue(n, n2);
    }

    public double getEndXValue(int n, int n2) {
        if (!this.transposed) {
            return this.getSeriesEndValue(n);
        }
        return this.getItemEndValue(n, n2);
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public Number getStartX(int n, int n2) {
        return new Double(this.getStartXValue(n, n2));
    }

    public Number getEndX(int n, int n2) {
        return new Double(this.getEndXValue(n, n2));
    }

    public double getYValue(int n, int n2) {
        if (!this.transposed) {
            return this.getItemValue(n, n2);
        }
        return this.getSeriesValue(n);
    }

    public double getStartYValue(int n, int n2) {
        if (!this.transposed) {
            return this.getItemStartValue(n, n2);
        }
        return this.getSeriesStartValue(n);
    }

    public double getEndYValue(int n, int n2) {
        if (!this.transposed) {
            return this.getItemEndValue(n, n2);
        }
        return this.getSeriesEndValue(n);
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public Number getStartY(int n, int n2) {
        return new Double(this.getStartYValue(n, n2));
    }

    public Number getEndY(int n, int n2) {
        return new Double(this.getEndYValue(n, n2));
    }

    private double getSeriesValue(int n) {
        return n;
    }

    private double getSeriesStartValue(int n) {
        return (double)n - this.seriesWidth / 2.0;
    }

    private double getSeriesEndValue(int n) {
        return (double)n + this.seriesWidth / 2.0;
    }

    private double getItemValue(int n, int n2) {
        TaskSeries taskSeries = this.underlying.getSeries(n);
        Task task = taskSeries.get(n2);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getStart();
        Date date2 = timePeriod.getEnd();
        return (double)(date.getTime() + date2.getTime()) / 2.0;
    }

    private double getItemStartValue(int n, int n2) {
        TaskSeries taskSeries = this.underlying.getSeries(n);
        Task task = taskSeries.get(n2);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getStart();
        return date.getTime();
    }

    private double getItemEndValue(int n, int n2) {
        TaskSeries taskSeries = this.underlying.getSeries(n);
        Task task = taskSeries.get(n2);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getEnd();
        return date.getTime();
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYTaskDataset)) {
            return false;
        }
        XYTaskDataset xYTaskDataset = (XYTaskDataset)object;
        if (this.seriesWidth != xYTaskDataset.seriesWidth) {
            return false;
        }
        if (this.transposed != xYTaskDataset.transposed) {
            return false;
        }
        return this.underlying.equals(xYTaskDataset.underlying);
    }

    public Object clone() throws CloneNotSupportedException {
        XYTaskDataset xYTaskDataset = (XYTaskDataset)super.clone();
        xYTaskDataset.underlying = (TaskSeriesCollection)this.underlying.clone();
        return xYTaskDataset;
    }
}

