/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.gantt;

import ai.org.jfree.data.UnknownKeyException;
import ai.org.jfree.data.gantt.GanttCategoryDataset;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SlidingGanttCategoryDataset
extends AbstractDataset
implements GanttCategoryDataset {
    private GanttCategoryDataset underlying;
    private int firstCategoryIndex;
    private int maximumCategoryCount;

    public SlidingGanttCategoryDataset(GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        this.underlying = ganttCategoryDataset;
        this.firstCategoryIndex = n;
        this.maximumCategoryCount = n2;
    }

    public GanttCategoryDataset getUnderlyingDataset() {
        return this.underlying;
    }

    public int getFirstCategoryIndex() {
        return this.firstCategoryIndex;
    }

    public void setFirstCategoryIndex(int n) {
        if (n < 0 || n >= this.underlying.getColumnCount()) {
            throw new IllegalArgumentException("Invalid index.");
        }
        this.firstCategoryIndex = n;
        this.fireDatasetChanged();
    }

    public int getMaximumCategoryCount() {
        return this.maximumCategoryCount;
    }

    public void setMaximumCategoryCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'max' >= 0.");
        }
        this.maximumCategoryCount = n;
        this.fireDatasetChanged();
    }

    private int lastCategoryIndex() {
        if (this.maximumCategoryCount == 0) {
            return -1;
        }
        return Math.min(this.firstCategoryIndex + this.maximumCategoryCount, this.underlying.getColumnCount()) - 1;
    }

    public int getColumnIndex(Comparable comparable) {
        int n = this.underlying.getColumnIndex(comparable);
        if (n >= this.firstCategoryIndex && n <= this.lastCategoryIndex()) {
            return n - this.firstCategoryIndex;
        }
        return -1;
    }

    public Comparable getColumnKey(int n) {
        return this.underlying.getColumnKey(n + this.firstCategoryIndex);
    }

    public List getColumnKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n = this.lastCategoryIndex();
        for (int i = this.firstCategoryIndex; i < n; ++i) {
            arrayList.add(this.underlying.getColumnKey(i));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public int getRowIndex(Comparable comparable) {
        return this.underlying.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.underlying.getRowKey(n);
    }

    public List getRowKeys() {
        return this.underlying.getRowKeys();
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        if (n2 != -1) {
            return this.underlying.getValue(n, n2 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public int getColumnCount() {
        int n = this.lastCategoryIndex();
        if (n == -1) {
            return 0;
        }
        return Math.max(n - this.firstCategoryIndex + 1, 0);
    }

    public int getRowCount() {
        return this.underlying.getRowCount();
    }

    public Number getValue(int n, int n2) {
        return this.underlying.getValue(n, n2 + this.firstCategoryIndex);
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        if (n2 != -1) {
            return this.underlying.getPercentComplete(n, n2 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getPercentComplete(n2, n3 + this.firstCategoryIndex, n);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getEndValue(n2, n3 + this.firstCategoryIndex, n);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getEndValue(int n, int n2, int n3) {
        return this.underlying.getEndValue(n, n2 + this.firstCategoryIndex, n3);
    }

    public Number getPercentComplete(int n, int n2) {
        return this.underlying.getPercentComplete(n, n2 + this.firstCategoryIndex);
    }

    public Number getPercentComplete(int n, int n2, int n3) {
        return this.underlying.getPercentComplete(n, n2 + this.firstCategoryIndex, n3);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2, int n) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getStartValue(n2, n3 + this.firstCategoryIndex, n);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getStartValue(int n, int n2, int n3) {
        return this.underlying.getStartValue(n, n2 + this.firstCategoryIndex, n3);
    }

    public int getSubIntervalCount(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        if (n2 != -1) {
            return this.underlying.getSubIntervalCount(n, n2 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public int getSubIntervalCount(int n, int n2) {
        return this.underlying.getSubIntervalCount(n, n2 + this.firstCategoryIndex);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        if (n2 != -1) {
            return this.underlying.getStartValue(n, n2 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getStartValue(int n, int n2) {
        return this.underlying.getStartValue(n, n2 + this.firstCategoryIndex);
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        if (n2 != -1) {
            return this.underlying.getEndValue(n, n2 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    public Number getEndValue(int n, int n2) {
        return this.underlying.getEndValue(n, n2 + this.firstCategoryIndex);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SlidingGanttCategoryDataset)) {
            return false;
        }
        SlidingGanttCategoryDataset slidingGanttCategoryDataset = (SlidingGanttCategoryDataset)object;
        if (this.firstCategoryIndex != slidingGanttCategoryDataset.firstCategoryIndex) {
            return false;
        }
        if (this.maximumCategoryCount != slidingGanttCategoryDataset.maximumCategoryCount) {
            return false;
        }
        return this.underlying.equals(slidingGanttCategoryDataset.underlying);
    }

    public Object clone() throws CloneNotSupportedException {
        SlidingGanttCategoryDataset slidingGanttCategoryDataset = (SlidingGanttCategoryDataset)super.clone();
        if (this.underlying instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.underlying);
            slidingGanttCategoryDataset.underlying = (GanttCategoryDataset)publicCloneable.clone();
        }
        return slidingGanttCategoryDataset;
    }
}

