/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.data.KeyedObject;
import ai.org.jfree.data.UnknownKeyException;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class KeyedObjects
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1321582394193530984L;
    private List data = new ArrayList();

    public int getItemCount() {
        return this.data.size();
    }

    public Object getObject(int n) {
        Object object = null;
        KeyedObject keyedObject = (KeyedObject)this.data.get(n);
        if (keyedObject != null) {
            object = keyedObject.getObject();
        }
        return object;
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        KeyedObject keyedObject = (KeyedObject)this.data.get(n);
        if (keyedObject != null) {
            comparable = keyedObject.getKey();
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n = 0;
        for (KeyedObject keyedObject : this.data) {
            if (keyedObject.getKey().equals(comparable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (KeyedObject keyedObject : this.data) {
            arrayList.add(keyedObject.getKey());
        }
        return arrayList;
    }

    public Object getObject(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("The key (" + comparable + ") is not recognised.");
        }
        return this.getObject(n);
    }

    public void addObject(Comparable comparable, Object object) {
        this.setObject(comparable, object);
    }

    public void setObject(Comparable comparable, Object object) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            KeyedObject keyedObject = (KeyedObject)this.data.get(n);
            keyedObject.setObject(object);
        } else {
            KeyedObject keyedObject = new KeyedObject(comparable, object);
            this.data.add(keyedObject);
        }
    }

    public void insertValue(int n, Comparable comparable, Object object) {
        if (n < 0 || n > this.data.size()) {
            throw new IllegalArgumentException("'position' out of bounds.");
        }
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n2 = this.getIndex(comparable);
        if (n2 >= 0) {
            this.data.remove(n2);
        }
        KeyedObject keyedObject = new KeyedObject(comparable, object);
        if (n <= this.data.size()) {
            this.data.add(n, keyedObject);
        } else {
            this.data.add(keyedObject);
        }
    }

    public void removeValue(int n) {
        this.data.remove(n);
    }

    public void removeValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("The key (" + comparable.toString() + ") is not recognised.");
        }
        this.removeValue(n);
    }

    public void clear() {
        this.data.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects keyedObjects = (KeyedObjects)super.clone();
        keyedObjects.data = new ArrayList();
        for (KeyedObject keyedObject : this.data) {
            keyedObjects.data.add(keyedObject.clone());
        }
        return keyedObjects;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects)) {
            return false;
        }
        KeyedObjects keyedObjects = (KeyedObjects)object;
        int n = this.getItemCount();
        if (n != keyedObjects.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = keyedObjects.getKey(i))) {
                return false;
            }
            Object object2 = this.getObject(i);
            Object object3 = keyedObjects.getObject(i);
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }
}

