/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.data.DefaultKeyedValue;
import ai.org.jfree.data.KeyedValueComparator;
import ai.org.jfree.data.KeyedValueComparatorType;
import ai.org.jfree.data.KeyedValues;
import ai.org.jfree.data.UnknownKeyException;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DefaultKeyedValues
implements KeyedValues,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8468154364608194797L;
    private ArrayList keys = new ArrayList();
    private ArrayList values = new ArrayList();
    private HashMap indexMap = new HashMap();

    public int getItemCount() {
        return this.indexMap.size();
    }

    public Number getValue(int n) {
        return (Number)this.values.get(n);
    }

    public Comparable getKey(int n) {
        return (Comparable)this.keys.get(n);
    }

    public int getIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Integer n = (Integer)this.indexMap.get(comparable);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public List getKeys() {
        return (List)this.keys.clone();
    }

    public Number getValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Key not found: " + comparable);
        }
        return this.getValue(n);
    }

    public void addValue(Comparable comparable, double d) {
        this.addValue(comparable, new Double(d));
    }

    public void addValue(Comparable comparable, Number number) {
        this.setValue(comparable, number);
    }

    public void setValue(Comparable comparable, double d) {
        this.setValue(comparable, new Double(d));
    }

    public void setValue(Comparable comparable, Number number) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n = this.getIndex(comparable);
        if (n >= 0) {
            this.keys.set(n, comparable);
            this.values.set(n, number);
        } else {
            this.keys.add(comparable);
            this.values.add(number);
            this.indexMap.put(comparable, new Integer(this.keys.size() - 1));
        }
    }

    public void insertValue(int n, Comparable comparable, double d) {
        this.insertValue(n, comparable, new Double(d));
    }

    public void insertValue(int n, Comparable comparable, Number number) {
        if (n < 0 || n > this.getItemCount()) {
            throw new IllegalArgumentException("'position' out of bounds.");
        }
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int n2 = this.getIndex(comparable);
        if (n2 == n) {
            this.keys.set(n2, comparable);
            this.values.set(n2, number);
        } else {
            if (n2 >= 0) {
                this.keys.remove(n2);
                this.values.remove(n2);
            }
            this.keys.add(n, comparable);
            this.values.add(n, number);
            this.rebuildIndex();
        }
    }

    private void rebuildIndex() {
        this.indexMap.clear();
        for (int i = 0; i < this.keys.size(); ++i) {
            Object e = this.keys.get(i);
            this.indexMap.put(e, new Integer(i));
        }
    }

    public void removeValue(int n) {
        this.keys.remove(n);
        this.values.remove(n);
        this.rebuildIndex();
    }

    public void removeValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("The key (" + comparable + ") is not recognised.");
        }
        this.removeValue(n);
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
        this.indexMap.clear();
    }

    public void sortByKeys(SortOrder sortOrder) {
        int n = this.keys.size();
        DefaultKeyedValue[] defaultKeyedValueArray = new DefaultKeyedValue[n];
        for (int i = 0; i < n; ++i) {
            defaultKeyedValueArray[i] = new DefaultKeyedValue((Comparable)this.keys.get(i), (Number)this.values.get(i));
        }
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_KEY, sortOrder);
        Arrays.sort(defaultKeyedValueArray, keyedValueComparator);
        this.clear();
        for (int i = 0; i < defaultKeyedValueArray.length; ++i) {
            DefaultKeyedValue defaultKeyedValue = defaultKeyedValueArray[i];
            this.addValue(defaultKeyedValue.getKey(), defaultKeyedValue.getValue());
        }
    }

    public void sortByValues(SortOrder sortOrder) {
        int n = this.keys.size();
        DefaultKeyedValue[] defaultKeyedValueArray = new DefaultKeyedValue[n];
        for (int i = 0; i < n; ++i) {
            defaultKeyedValueArray[i] = new DefaultKeyedValue((Comparable)this.keys.get(i), (Number)this.values.get(i));
        }
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_VALUE, sortOrder);
        Arrays.sort(defaultKeyedValueArray, keyedValueComparator);
        this.clear();
        for (int i = 0; i < defaultKeyedValueArray.length; ++i) {
            DefaultKeyedValue defaultKeyedValue = defaultKeyedValueArray[i];
            this.addValue(defaultKeyedValue.getKey(), defaultKeyedValue.getValue());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues)) {
            return false;
        }
        KeyedValues keyedValues = (KeyedValues)object;
        int n = this.getItemCount();
        if (n != keyedValues.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = keyedValues.getKey(i))) {
                return false;
            }
            Number number = this.getValue(i);
            Number number2 = keyedValues.getValue(i);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.keys != null ? this.keys.hashCode() : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)super.clone();
        defaultKeyedValues.keys = (ArrayList)this.keys.clone();
        defaultKeyedValues.values = (ArrayList)this.values.clone();
        defaultKeyedValues.indexMap = (HashMap)this.indexMap.clone();
        return defaultKeyedValues;
    }
}

