/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.data.ComparableObjectItem;
import ai.org.jfree.data.general.Series;
import ai.org.jfree.data.general.SeriesException;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComparableObjectSeries
extends Series
implements Cloneable,
Serializable {
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;

    public ComparableObjectSeries(Comparable comparable) {
        this(comparable, true, true);
    }

    public ComparableObjectSeries(Comparable comparable, boolean bl, boolean bl2) {
        super(comparable);
        this.data = new ArrayList();
        this.autoSort = bl;
        this.allowDuplicateXValues = bl2;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
        boolean bl = false;
        while (this.data.size() > n) {
            this.data.remove(0);
            bl = true;
        }
        if (bl) {
            this.fireSeriesChanged();
        }
    }

    protected void add(Comparable comparable, Object object) {
        this.add(comparable, object, true);
    }

    protected void add(Comparable comparable, Object object, boolean bl) {
        ComparableObjectItem comparableObjectItem = new ComparableObjectItem(comparable, object);
        this.add(comparableObjectItem, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void add(ComparableObjectItem comparableObjectItem, boolean bl) {
        if (comparableObjectItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        if (this.autoSort) {
            int n = Collections.binarySearch(this.data, comparableObjectItem);
            if (n < 0) {
                this.data.add(-n - 1, comparableObjectItem);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int n2 = this.data.size();
                while (n < n2 && comparableObjectItem.compareTo(this.data.get(n)) == 0) {
                    ++n;
                }
                if (n < this.data.size()) {
                    this.data.add(n, comparableObjectItem);
                } else {
                    this.data.add(comparableObjectItem);
                }
            }
        } else {
            int n;
            if (!this.allowDuplicateXValues && (n = this.indexOf(comparableObjectItem.getComparable())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(comparableObjectItem);
        }
        if (this.getItemCount() > this.maximumItemCount) {
            this.data.remove(0);
        }
        if (!bl) return;
        this.fireSeriesChanged();
    }

    public int indexOf(Comparable comparable) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new ComparableObjectItem(comparable, null));
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ComparableObjectItem comparableObjectItem = (ComparableObjectItem)this.data.get(i);
            if (!comparableObjectItem.getComparable().equals(comparable)) continue;
            return i;
        }
        return -1;
    }

    protected void update(Comparable comparable, Object object) {
        int n = this.indexOf(comparable);
        if (n < 0) {
            throw new SeriesException("No observation for x = " + comparable);
        }
        ComparableObjectItem comparableObjectItem = this.getDataItem(n);
        comparableObjectItem.setObject(object);
        this.fireSeriesChanged();
    }

    protected void updateByIndex(int n, Object object) {
        ComparableObjectItem comparableObjectItem = this.getDataItem(n);
        comparableObjectItem.setObject(object);
        this.fireSeriesChanged();
    }

    protected ComparableObjectItem getDataItem(int n) {
        return (ComparableObjectItem)this.data.get(n);
    }

    protected void delete(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.data.remove(n);
        }
        this.fireSeriesChanged();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    protected ComparableObjectItem remove(int n) {
        ComparableObjectItem comparableObjectItem = (ComparableObjectItem)this.data.remove(n);
        this.fireSeriesChanged();
        return comparableObjectItem;
    }

    public ComparableObjectItem remove(Comparable comparable) {
        return this.remove(this.indexOf(comparable));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ComparableObjectSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ComparableObjectSeries comparableObjectSeries = (ComparableObjectSeries)object;
        if (this.maximumItemCount != comparableObjectSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != comparableObjectSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != comparableObjectSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, comparableObjectSeries.data);
    }

    public int hashCode() {
        ComparableObjectItem comparableObjectItem;
        int n = super.hashCode();
        int n2 = this.getItemCount();
        if (n2 > 0) {
            comparableObjectItem = this.getDataItem(0);
            n = 29 * n + comparableObjectItem.hashCode();
        }
        if (n2 > 1) {
            comparableObjectItem = this.getDataItem(n2 - 1);
            n = 29 * n + comparableObjectItem.hashCode();
        }
        if (n2 > 2) {
            comparableObjectItem = this.getDataItem(n2 / 2);
            n = 29 * n + comparableObjectItem.hashCode();
        }
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + (this.autoSort ? 1 : 0);
        n = 29 * n + (this.allowDuplicateXValues ? 1 : 0);
        return n;
    }
}

