/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;

public class RelativeDateFormat
extends DateFormat {
    private long baseMillis;
    private boolean showZeroDays;
    private boolean showZeroHours;
    private NumberFormat dayFormatter;
    private String positivePrefix;
    private String daySuffix;
    private NumberFormat hourFormatter;
    private String hourSuffix;
    private NumberFormat minuteFormatter;
    private String minuteSuffix;
    private NumberFormat secondFormatter;
    private String secondSuffix;
    private static long MILLISECONDS_IN_ONE_HOUR = 3600000L;
    private static long MILLISECONDS_IN_ONE_DAY = 24L * MILLISECONDS_IN_ONE_HOUR;

    public RelativeDateFormat() {
        this(0L);
    }

    public RelativeDateFormat(Date date) {
        this(date.getTime());
    }

    public RelativeDateFormat(long l) {
        this.baseMillis = l;
        this.showZeroDays = false;
        this.showZeroHours = true;
        this.positivePrefix = "";
        this.dayFormatter = NumberFormat.getNumberInstance();
        this.daySuffix = "d";
        this.hourFormatter = NumberFormat.getNumberInstance();
        this.hourSuffix = "h";
        this.minuteFormatter = NumberFormat.getNumberInstance();
        this.minuteSuffix = "m";
        this.secondFormatter = NumberFormat.getNumberInstance();
        this.secondFormatter.setMaximumFractionDigits(3);
        this.secondFormatter.setMinimumFractionDigits(3);
        this.secondSuffix = "s";
        this.calendar = new GregorianCalendar();
        this.numberFormat = new DecimalFormat("0");
    }

    public long getBaseMillis() {
        return this.baseMillis;
    }

    public void setBaseMillis(long l) {
        this.baseMillis = l;
    }

    public boolean getShowZeroDays() {
        return this.showZeroDays;
    }

    public void setShowZeroDays(boolean bl) {
        this.showZeroDays = bl;
    }

    public boolean getShowZeroHours() {
        return this.showZeroHours;
    }

    public void setShowZeroHours(boolean bl) {
        this.showZeroHours = bl;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        this.positivePrefix = string;
    }

    public void setDayFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.dayFormatter = numberFormat;
    }

    public String getDaySuffix() {
        return this.daySuffix;
    }

    public void setDaySuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'suffix' argument.");
        }
        this.daySuffix = string;
    }

    public void setHourFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.hourFormatter = numberFormat;
    }

    public String getHourSuffix() {
        return this.hourSuffix;
    }

    public void setHourSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'suffix' argument.");
        }
        this.hourSuffix = string;
    }

    public void setMinuteFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.minuteFormatter = numberFormat;
    }

    public String getMinuteSuffix() {
        return this.minuteSuffix;
    }

    public void setMinuteSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'suffix' argument.");
        }
        this.minuteSuffix = string;
    }

    public String getSecondSuffix() {
        return this.secondSuffix;
    }

    public void setSecondSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'suffix' argument.");
        }
        this.secondSuffix = string;
    }

    public void setSecondFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.secondFormatter = numberFormat;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string;
        long l = date.getTime();
        long l2 = l - this.baseMillis;
        if (l2 < 0L) {
            l2 *= -1L;
            string = "-";
        } else {
            string = this.positivePrefix;
        }
        long l3 = l2 / MILLISECONDS_IN_ONE_DAY;
        long l4 = (l2 -= l3 * MILLISECONDS_IN_ONE_DAY) / MILLISECONDS_IN_ONE_HOUR;
        long l5 = (l2 -= l4 * MILLISECONDS_IN_ONE_HOUR) / 60000L;
        double d = (double)(l2 -= l5 * 60000L) / 1000.0;
        stringBuffer.append(string);
        if (l3 != 0L || this.showZeroDays) {
            stringBuffer.append(this.dayFormatter.format(l3) + this.getDaySuffix());
        }
        if (l4 != 0L || this.showZeroHours) {
            stringBuffer.append(this.hourFormatter.format(l4) + this.getHourSuffix());
        }
        stringBuffer.append(this.minuteFormatter.format(l5) + this.getMinuteSuffix());
        stringBuffer.append(this.secondFormatter.format(d) + this.getSecondSuffix());
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RelativeDateFormat)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RelativeDateFormat relativeDateFormat = (RelativeDateFormat)object;
        if (this.baseMillis != relativeDateFormat.baseMillis) {
            return false;
        }
        if (this.showZeroDays != relativeDateFormat.showZeroDays) {
            return false;
        }
        if (this.showZeroHours != relativeDateFormat.showZeroHours) {
            return false;
        }
        if (!this.positivePrefix.equals(relativeDateFormat.positivePrefix)) {
            return false;
        }
        if (!this.daySuffix.equals(relativeDateFormat.daySuffix)) {
            return false;
        }
        if (!this.hourSuffix.equals(relativeDateFormat.hourSuffix)) {
            return false;
        }
        if (!this.minuteSuffix.equals(relativeDateFormat.minuteSuffix)) {
            return false;
        }
        if (!this.secondSuffix.equals(relativeDateFormat.secondSuffix)) {
            return false;
        }
        if (!this.dayFormatter.equals(relativeDateFormat.dayFormatter)) {
            return false;
        }
        if (!this.hourFormatter.equals(relativeDateFormat.hourFormatter)) {
            return false;
        }
        if (!this.minuteFormatter.equals(relativeDateFormat.minuteFormatter)) {
            return false;
        }
        return this.secondFormatter.equals(relativeDateFormat.secondFormatter);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + (int)(this.baseMillis ^ this.baseMillis >>> 32);
        n = 37 * n + this.positivePrefix.hashCode();
        n = 37 * n + this.daySuffix.hashCode();
        n = 37 * n + this.hourSuffix.hashCode();
        n = 37 * n + this.minuteSuffix.hashCode();
        n = 37 * n + this.secondSuffix.hashCode();
        n = 37 * n + this.secondFormatter.hashCode();
        return n;
    }

    public Object clone() {
        RelativeDateFormat relativeDateFormat = (RelativeDateFormat)super.clone();
        relativeDateFormat.dayFormatter = (NumberFormat)this.dayFormatter.clone();
        relativeDateFormat.secondFormatter = (NumberFormat)this.secondFormatter.clone();
        return relativeDateFormat;
    }

    public static void main(String[] stringArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2006, 10, 1, 0, 0, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2006, 10, 1, 11, 37, 43);
        gregorianCalendar2.set(14, 123);
        System.out.println("Default: ");
        RelativeDateFormat relativeDateFormat = new RelativeDateFormat(gregorianCalendar.getTime().getTime());
        System.out.println(relativeDateFormat.format(gregorianCalendar2.getTime()));
        System.out.println();
        System.out.println("Hide milliseconds: ");
        relativeDateFormat.setSecondFormatter(new DecimalFormat("0"));
        System.out.println(relativeDateFormat.format(gregorianCalendar2.getTime()));
        System.out.println();
        System.out.println("Show zero day output: ");
        relativeDateFormat.setShowZeroDays(true);
        System.out.println(relativeDateFormat.format(gregorianCalendar2.getTime()));
        System.out.println();
        System.out.println("Alternative suffixes: ");
        relativeDateFormat.setShowZeroDays(false);
        relativeDateFormat.setDaySuffix(":");
        relativeDateFormat.setHourSuffix(":");
        relativeDateFormat.setMinuteSuffix(":");
        relativeDateFormat.setSecondSuffix("");
        System.out.println(relativeDateFormat.format(gregorianCalendar2.getTime()));
        System.out.println();
    }
}

