/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.urls;

import ai.org.jfree.chart.urls.URLUtilities;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class TimeSeriesURLGenerator
implements XYURLGenerator,
Serializable {
    private static final long serialVersionUID = -9122773175671182445L;
    private DateFormat dateFormat = DateFormat.getInstance();
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public TimeSeriesURLGenerator() {
    }

    public TimeSeriesURLGenerator(DateFormat dateFormat, String string, String string2, String string3) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'dateFormat' argument.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'seriesParameterName' argument.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Null 'itemParameterName' argument.");
        }
        this.dateFormat = (DateFormat)dateFormat.clone();
        this.prefix = string;
        this.seriesParameterName = string2;
        this.itemParameterName = string3;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormat.clone();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSeriesParameterName() {
        return this.seriesParameterName;
    }

    public String getItemParameterName() {
        return this.itemParameterName;
    }

    public String generateURL(XYDataset xYDataset, int n, int n2) {
        String string = this.prefix;
        boolean bl = string.indexOf("?") == -1;
        Comparable comparable = xYDataset.getSeriesKey(n);
        if (comparable != null) {
            string = string + (bl ? "?" : "&amp;");
            string = string + this.seriesParameterName + "=" + URLUtilities.encode(comparable.toString(), "UTF-8");
            bl = false;
        }
        long l = (long)xYDataset.getXValue(n, n2);
        String string2 = this.dateFormat.format(new Date(l));
        string = string + (bl ? "?" : "&amp;");
        string = string + this.itemParameterName + "=" + URLUtilities.encode(string2, "UTF-8");
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeriesURLGenerator)) {
            return false;
        }
        TimeSeriesURLGenerator timeSeriesURLGenerator = (TimeSeriesURLGenerator)object;
        if (!this.dateFormat.equals(timeSeriesURLGenerator.dateFormat)) {
            return false;
        }
        if (!this.itemParameterName.equals(timeSeriesURLGenerator.itemParameterName)) {
            return false;
        }
        if (!this.prefix.equals(timeSeriesURLGenerator.prefix)) {
            return false;
        }
        return this.seriesParameterName.equals(timeSeriesURLGenerator.seriesParameterName);
    }
}

