/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.urls;

import ai.org.jfree.chart.urls.PieURLGenerator;
import ai.org.jfree.chart.urls.URLUtilities;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;

public class StandardPieURLGenerator
implements PieURLGenerator,
Serializable {
    private static final long serialVersionUID = 1626966402065883419L;
    private String prefix = "index.html";
    private String categoryParameterName = "category";
    private String indexParameterName = "pieIndex";

    public StandardPieURLGenerator() {
        this("index.html");
    }

    public StandardPieURLGenerator(String string) {
        this(string, "category");
    }

    public StandardPieURLGenerator(String string, String string2) {
        this(string, string2, "pieIndex");
    }

    public StandardPieURLGenerator(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'categoryParameterName' argument.");
        }
        this.prefix = string;
        this.categoryParameterName = string2;
        this.indexParameterName = string3;
    }

    public String generateURL(PieDataset pieDataset, Comparable comparable, int n) {
        String string = this.prefix;
        string = string.indexOf("?") > -1 ? string + "&amp;" + this.categoryParameterName + "=" + URLUtilities.encode(comparable.toString(), "UTF-8") : string + "?" + this.categoryParameterName + "=" + URLUtilities.encode(comparable.toString(), "UTF-8");
        if (this.indexParameterName != null) {
            string = string + "&amp;" + this.indexParameterName + "=" + String.valueOf(n);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardPieURLGenerator)) {
            return false;
        }
        StandardPieURLGenerator standardPieURLGenerator = (StandardPieURLGenerator)object;
        if (!this.prefix.equals(standardPieURLGenerator.prefix)) {
            return false;
        }
        if (!this.categoryParameterName.equals(standardPieURLGenerator.categoryParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(this.indexParameterName, standardPieURLGenerator.indexParameterName);
    }
}

