/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.urls;

import ai.org.jfree.chart.urls.CategoryURLGenerator;
import ai.org.jfree.chart.urls.URLUtilities;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;

public class StandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2276668053074881909L;
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        this.prefix = string;
    }

    public StandardCategoryURLGenerator(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'seriesParameterName' argument.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Null 'categoryParameterName' argument.");
        }
        this.prefix = string;
        this.seriesParameterName = string2;
        this.categoryParameterName = string3;
    }

    public String generateURL(CategoryDataset categoryDataset, int n, int n2) {
        String string = this.prefix;
        Comparable comparable = categoryDataset.getRowKey(n);
        Comparable comparable2 = categoryDataset.getColumnKey(n2);
        boolean bl = string.indexOf("?") == -1;
        string = string + (bl ? "?" : "&amp;");
        string = string + this.seriesParameterName + "=" + URLUtilities.encode(comparable.toString(), "UTF-8");
        string = string + "&amp;" + this.categoryParameterName + "=" + URLUtilities.encode(comparable2.toString(), "UTF-8");
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = (StandardCategoryURLGenerator)object;
        if (!ObjectUtilities.equal(this.prefix, standardCategoryURLGenerator.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesParameterName, standardCategoryURLGenerator.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(this.categoryParameterName, standardCategoryURLGenerator.categoryParameterName);
    }

    public int hashCode() {
        int n = this.prefix != null ? this.prefix.hashCode() : 0;
        n = 29 * n + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        n = 29 * n + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return n;
    }
}

