/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.title;

import ai.org.jfree.chart.block.LengthConstraintType;
import ai.org.jfree.chart.block.RectangleConstraint;
import ai.org.jfree.chart.title.TextTitle;
import ai.org.jfree.data.Range;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.ui.TextAnchor;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ShortTextTitle
extends TextTitle {
    public ShortTextTitle(String string) {
        this.setText(string);
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        Size2D size2D = null;
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeNN(graphics2D);
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeRN(graphics2D, rectangleConstraint2.getWidthRange());
            } else if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                size2D = this.arrangeRR(graphics2D, rectangleConstraint2.getWidthRange(), rectangleConstraint2.getHeightRange());
            } else if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeFN(graphics2D, rectangleConstraint2.getWidth());
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        if (size2D.width <= 0.0 || size2D.height <= 0.0) {
            return new Size2D(0.0, 0.0);
        }
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    protected Size2D arrangeNN(Graphics2D graphics2D) {
        Range range = new Range(0.0, 3.4028234663852886E38);
        return this.arrangeRR(graphics2D, range, range);
    }

    protected Size2D arrangeRN(Graphics2D graphics2D, Range range) {
        Size2D size2D = this.arrangeNN(graphics2D);
        if (range.contains(size2D.getWidth())) {
            return size2D;
        }
        double d = range.constrain(size2D.getWidth());
        return this.arrangeFN(graphics2D, d);
    }

    protected Size2D arrangeFN(Graphics2D graphics2D, double d) {
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(this.getText(), graphics2D, fontMetrics);
        if (rectangle2D.getWidth() <= d) {
            return new Size2D(d, rectangle2D.getHeight());
        }
        return new Size2D(0.0, 0.0);
    }

    protected Size2D arrangeRR(Graphics2D graphics2D, Range range, Range range2) {
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(this.getText(), graphics2D, fontMetrics);
        if (rectangle2D.getWidth() <= range.getUpperBound() && rectangle2D.getHeight() <= range2.getUpperBound()) {
            return new Size2D(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return new Size2D(0.0, 0.0);
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        if (rectangle2D.isEmpty()) {
            return null;
        }
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        TextUtilities.drawAlignedString(this.getText(), graphics2D, (float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), TextAnchor.TOP_LEFT);
        return null;
    }
}

