/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.title;

import ai.org.jfree.chart.block.BlockContainer;
import ai.org.jfree.chart.block.BorderArrangement;
import ai.org.jfree.chart.block.RectangleConstraint;
import ai.org.jfree.chart.event.TitleChangeEvent;
import ai.org.jfree.chart.title.Title;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CompositeTitle
extends Title
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6770854036232562290L;
    private transient Paint backgroundPaint;
    private BlockContainer container;

    public CompositeTitle() {
        this(new BlockContainer(new BorderArrangement()));
    }

    public CompositeTitle(BlockContainer blockContainer) {
        if (blockContainer == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = blockContainer;
        this.backgroundPaint = null;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public BlockContainer getContainer() {
        return this.container;
    }

    public void setTitleContainer(BlockContainer blockContainer) {
        if (blockContainer == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = blockContainer;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        Size2D size2D = this.container.arrange(graphics2D, rectangleConstraint2);
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        rectangle2D = this.trimPadding(rectangle2D);
        return this.container.draw(graphics2D, rectangle2D, object);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompositeTitle)) {
            return false;
        }
        CompositeTitle compositeTitle = (CompositeTitle)object;
        if (!this.container.equals(compositeTitle.container)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, compositeTitle.backgroundPaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

