/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XYStepAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7311560779702649635L;
    public static final int SHAPES = 1;
    public static final int AREA = 2;
    public static final int AREA_AND_SHAPES = 3;
    private boolean shapesVisible;
    private boolean shapesFilled;
    private boolean plotArea;
    private boolean showOutline;
    protected transient Polygon pArea = null;
    private double rangeBase;

    public XYStepAreaRenderer() {
        this(2);
    }

    public XYStepAreaRenderer(int n) {
        this(n, null, null);
    }

    public XYStepAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 2) {
            this.plotArea = true;
        } else if (n == 1) {
            this.shapesVisible = true;
        } else if (n == 3) {
            this.plotArea = true;
            this.shapesVisible = true;
        }
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
        this.fireChangeEvent();
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl) {
        this.shapesVisible = bl;
        this.fireChangeEvent();
    }

    public boolean isShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.shapesFilled = bl;
        this.fireChangeEvent();
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(boolean bl) {
        this.plotArea = bl;
        this.fireChangeEvent();
    }

    public double getRangeBase() {
        return this.rangeBase;
    }

    public void setRangeBase(double d) {
        this.rangeBase = d;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        xYItemRendererState.setProcessVisibleItemsOnly(false);
        return xYItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        double d;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        int n4 = xYDataset.getItemCount(n);
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d2 = xYDataset.getXValue(n, n2);
        double d3 = xYDataset.getYValue(n, n2);
        double d4 = d2;
        double d5 = Double.isNaN(d3) ? this.getRangeBase() : d3;
        double d6 = valueAxis.valueToJava2D(d4, rectangle2D, xYPlot.getDomainAxisEdge());
        double d7 = valueAxis2.valueToJava2D(d5, rectangle2D, xYPlot.getRangeAxisEdge());
        d7 = XYStepAreaRenderer.restrictValueToDataArea(d7, xYPlot, rectangle2D);
        if (this.pArea == null && !Double.isNaN(d3)) {
            this.pArea = new Polygon();
            d = valueAxis2.valueToJava2D(this.getRangeBase(), rectangle2D, xYPlot.getRangeAxisEdge());
            d = XYStepAreaRenderer.restrictValueToDataArea(d, xYPlot, rectangle2D);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d6, (int)d);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d, (int)d6);
            }
        }
        d = 0.0;
        if (n2 > 0) {
            double d8 = xYDataset.getXValue(n, n2 - 1);
            double d9 = Double.isNaN(d3) ? d3 : xYDataset.getYValue(n, n2 - 1);
            d4 = d8;
            d5 = Double.isNaN(d9) ? this.getRangeBase() : d9;
            d = valueAxis.valueToJava2D(d4, rectangle2D, xYPlot.getDomainAxisEdge());
            double d10 = valueAxis2.valueToJava2D(d5, rectangle2D, xYPlot.getRangeAxisEdge());
            d10 = XYStepAreaRenderer.restrictValueToDataArea(d10, xYPlot, rectangle2D);
            if (Double.isNaN(d3)) {
                d6 = d;
                d10 = d7;
            }
            if (d10 != d7) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.pArea.addPoint((int)d6, (int)d10);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.pArea.addPoint((int)d10, (int)d6);
                }
            }
        }
        Shape shape = null;
        if (!Double.isNaN(d3)) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d6, (int)d7);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d7, (int)d6);
            }
            if (this.getShapesVisible()) {
                shape = this.getItemShape(n, n2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    shape = ShapeUtilities.createTranslatedShape(shape, d6, d7);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    shape = ShapeUtilities.createTranslatedShape(shape, d7, d6);
                }
                if (this.isShapesFilled()) {
                    graphics2D.fill(shape);
                } else {
                    graphics2D.draw(shape);
                }
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = new Rectangle2D.Double(d6 - 2.0, d7 - 2.0, 4.0, 4.0);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = new Rectangle2D.Double(d7 - 2.0, d6 - 2.0, 4.0, 4.0);
            }
        }
        if (this.getPlotArea() && n2 > 0 && this.pArea != null && (n2 == n4 - 1 || Double.isNaN(d3))) {
            double d11 = valueAxis2.valueToJava2D(this.getRangeBase(), rectangle2D, xYPlot.getRangeAxisEdge());
            d11 = XYStepAreaRenderer.restrictValueToDataArea(d11, xYPlot, rectangle2D);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                this.pArea.addPoint((int)d6, (int)d11);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d11, (int)d6);
            }
            graphics2D.fill(this.pArea);
            if (this.isOutline()) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(this.pArea);
            }
            this.pArea = null;
        }
        if (!Double.isNaN(d3)) {
            int n5 = xYPlot.getDomainAxisIndex(valueAxis);
            int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d2, d3, n5, n6, d6, d7, plotOrientation);
        }
        if ((entityCollection = xYItemRendererState.getEntityCollection()) != null) {
            this.addEntity(entityCollection, shape, xYDataset, n, n2, d6, d7);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYStepAreaRenderer)) {
            return false;
        }
        XYStepAreaRenderer xYStepAreaRenderer = (XYStepAreaRenderer)object;
        if (this.showOutline != xYStepAreaRenderer.showOutline) {
            return false;
        }
        if (this.shapesVisible != xYStepAreaRenderer.shapesVisible) {
            return false;
        }
        if (this.shapesFilled != xYStepAreaRenderer.shapesFilled) {
            return false;
        }
        if (this.plotArea != xYStepAreaRenderer.plotArea) {
            return false;
        }
        if (this.rangeBase != xYStepAreaRenderer.rangeBase) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected static double restrictValueToDataArea(double d, XYPlot xYPlot, Rectangle2D rectangle2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            d2 = rectangle2D.getMinY();
            d3 = rectangle2D.getMaxY();
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            d2 = rectangle2D.getMinX();
            d3 = rectangle2D.getMaxX();
        }
        if (d < d2) {
            d = d2;
        } else if (d > d3) {
            d = d3;
        }
        return d;
    }
}

