/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private Vector points;
    private int precision;

    public XYSplineRenderer() {
        this(5);
    }

    public XYSplineRenderer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        this.precision = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = n;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYLineAndShapeRenderer.State state = (XYLineAndShapeRenderer.State)super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        state.setProcessVisibleItemsOnly(false);
        this.points = new Vector();
        this.setDrawSeriesLineAsPath(true);
        return state;
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        Object object;
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = xYDataset.getXValue(n2, n3);
        double d2 = xYDataset.getYValue(n2, n3);
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (!(Double.isNaN(d3) || Double.isNaN(d4) || this.points.contains(object = new ControlPoint(xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)d4 : (float)d3, xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)d3 : (float)d4)))) {
            this.points.add(object);
        }
        if (n3 == xYDataset.getItemCount(n2) - 1) {
            object = (XYLineAndShapeRenderer.State)xYItemRendererState;
            if (this.points.size() > 1) {
                ControlPoint controlPoint = (ControlPoint)this.points.get(0);
                ((XYLineAndShapeRenderer.State)object).seriesPath.moveTo(controlPoint.x, controlPoint.y);
                if (this.points.size() == 2) {
                    ControlPoint controlPoint2 = (ControlPoint)this.points.get(1);
                    ((XYLineAndShapeRenderer.State)object).seriesPath.lineTo(controlPoint2.x, controlPoint2.y);
                } else {
                    int n4;
                    Object object2;
                    int n5;
                    int n6 = this.points.size();
                    float[] fArray = new float[n6];
                    float[] fArray2 = new float[n6];
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float[] fArray3 = new float[n6];
                    float[] fArray4 = new float[n6];
                    for (n5 = 0; n5 < n6; ++n5) {
                        object2 = (ControlPoint)this.points.get(n5);
                        fArray2[n5] = ((ControlPoint)object2).x;
                        fArray[n5] = ((ControlPoint)object2).y;
                    }
                    for (n5 = 1; n5 <= n6 - 1; ++n5) {
                        fArray4[n5] = fArray2[n5] - fArray2[n5 - 1];
                    }
                    float[] fArray5 = new float[n6 - 1];
                    object2 = new float[n6 - 1];
                    float[] fArray6 = new float[n6 - 1];
                    for (n4 = 1; n4 <= n6 - 2; ++n4) {
                        object2[n4] = (fArray4[n4] + fArray4[n4 + 1]) / 3.0f;
                        fArray6[n4] = fArray4[n4 + 1] / 6.0f;
                        fArray5[n4] = fArray4[n4] / 6.0f;
                        fArray3[n4] = (fArray[n4 + 1] - fArray[n4]) / fArray4[n4 + 1] - (fArray[n4] - fArray[n4 - 1]) / fArray4[n4];
                    }
                    this.solveTridiag(fArray5, (float[])object2, fArray6, fArray3, n6 - 2);
                    f2 = fArray2[0];
                    f = fArray[0];
                    ((XYLineAndShapeRenderer.State)object).seriesPath.moveTo(f2, f);
                    for (n4 = 1; n4 <= n6 - 1; ++n4) {
                        for (int i = 1; i <= this.precision; ++i) {
                            float f3 = fArray4[n4] * (float)i / (float)this.precision;
                            float f4 = fArray4[n4] - f3;
                            float f5 = ((-fArray3[n4 - 1] / 6.0f * (f4 + fArray4[n4]) * f3 + fArray[n4 - 1]) * f4 + (-fArray3[n4] / 6.0f * (f3 + fArray4[n4]) * f4 + fArray[n4]) * f3) / fArray4[n4];
                            float f6 = fArray2[n4 - 1] + f3;
                            ((XYLineAndShapeRenderer.State)object).seriesPath.lineTo(f6, f5);
                        }
                    }
                }
                this.drawFirstPassShape(graphics2D, n, n2, n3, ((XYLineAndShapeRenderer.State)object).seriesPath);
            }
            this.points = new Vector();
        }
    }

    private void solveTridiag(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        int n2;
        for (n2 = 2; n2 <= n; ++n2) {
            fArray[n2] = fArray[n2] / fArray2[n2 - 1];
            fArray2[n2] = fArray2[n2] - fArray[n2] * fArray3[n2 - 1];
            fArray4[n2] = fArray4[n2] - fArray[n2] * fArray4[n2 - 1];
        }
        fArray4[n] = fArray4[n] / fArray2[n];
        for (n2 = n - 1; n2 >= 1; --n2) {
            fArray4[n2] = (fArray4[n2] - fArray3[n2] * fArray4[n2 + 1]) / fArray2[n2];
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer xYSplineRenderer = (XYSplineRenderer)object;
        if (this.precision != xYSplineRenderer.precision) {
            return false;
        }
        return super.equals(object);
    }

    class ControlPoint {
        public float x;
        public float y;

        public ControlPoint(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ControlPoint)) {
                return false;
            }
            ControlPoint controlPoint = (ControlPoint)object;
            return this.x == controlPoint.x;
        }
    }
}

