/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.LookupPaintScale;
import ai.org.jfree.chart.renderer.PaintScale;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYZDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XYShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8320552104211173221L;
    private PaintScale paintScale = new LookupPaintScale();
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = true;
    private boolean useFillPaint = false;
    private boolean guideLinesVisible = false;
    private transient Paint guideLinePaint = Color.darkGray;
    private transient Stroke guideLineStroke = new BasicStroke();

    public XYShapeRenderer() {
        this.setBaseShape(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
        this.setAutoPopulateSeriesShape(false);
    }

    public PaintScale getPaintScale() {
        return this.paintScale;
    }

    public void setPaintScale(PaintScale paintScale) {
        if (paintScale == null) {
            throw new IllegalArgumentException("Null 'scale' argument.");
        }
        this.paintScale = paintScale;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
        this.fireChangeEvent();
    }

    public boolean isGuideLinesVisible() {
        return this.guideLinesVisible;
    }

    public void setGuideLinesVisible(boolean bl) {
        this.guideLinesVisible = bl;
        this.fireChangeEvent();
    }

    public Paint getGuideLinePaint() {
        return this.guideLinePaint;
    }

    public void setGuideLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.guideLinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getGuideLineStroke() {
        return this.guideLineStroke;
    }

    public void setGuideLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.guideLineStroke = stroke;
        this.fireChangeEvent();
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        Range range = DatasetUtilities.findDomainBounds(xYDataset, false);
        if (range == null) {
            return null;
        }
        double d = 0.0;
        return new Range(range.getLowerBound() + d, range.getUpperBound() + d);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        Range range = DatasetUtilities.findRangeBounds(xYDataset, false);
        if (range == null) {
            return null;
        }
        double d = 0.0;
        return new Range(range.getLowerBound() + d, range.getUpperBound() + d);
    }

    public Range findZBounds(XYZDataset xYZDataset) {
        if (xYZDataset != null) {
            return DatasetUtilities.findZBounds(xYZDataset);
        }
        return null;
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return;
        }
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (n3 == 0 && this.guideLinesVisible) {
            graphics2D.setStroke(this.guideLineStroke);
            graphics2D.setPaint(this.guideLinePaint);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.draw(new Line2D.Double(d4, rectangle2D.getMinY(), d4, rectangle2D.getMaxY()));
                graphics2D.draw(new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3));
            } else {
                graphics2D.draw(new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY()));
                graphics2D.draw(new Line2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getMaxX(), d4));
            }
        } else if (n3 == 1) {
            Shape shape2 = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape2 = ShapeUtilities.createTranslatedShape(shape2, d4, d3);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape2 = ShapeUtilities.createTranslatedShape(shape2, d3, d4);
            }
            shape = shape2;
            if (shape2.intersects(rectangle2D)) {
                graphics2D.setPaint(this.getPaint(xYDataset, n, n2));
                graphics2D.fill(shape2);
                if (this.drawOutlines) {
                    if (this.getUseOutlinePaint()) {
                        graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n, n2));
                    }
                    graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                    graphics2D.draw(shape2);
                }
            }
            if (entityCollection != null) {
                this.addEntity(entityCollection, shape, xYDataset, n, n2, d3, d4);
            }
        }
    }

    protected Paint getPaint(XYDataset xYDataset, int n, int n2) {
        Paint paint = null;
        if (xYDataset instanceof XYZDataset) {
            double d = ((XYZDataset)xYDataset).getZValue(n, n2);
            paint = this.paintScale.getPaint(d);
        } else {
            paint = this.useFillPaint ? this.getItemFillPaint(n, n2) : this.getItemPaint(n, n2);
        }
        return paint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYShapeRenderer)) {
            return false;
        }
        XYShapeRenderer xYShapeRenderer = (XYShapeRenderer)object;
        if (!this.paintScale.equals(xYShapeRenderer.paintScale)) {
            return false;
        }
        if (this.drawOutlines != xYShapeRenderer.drawOutlines) {
            return false;
        }
        if (this.useOutlinePaint != xYShapeRenderer.useOutlinePaint) {
            return false;
        }
        if (this.useFillPaint != xYShapeRenderer.useFillPaint) {
            return false;
        }
        if (this.guideLinesVisible != xYShapeRenderer.guideLinesVisible) {
            return false;
        }
        if (!this.guideLinePaint.equals(xYShapeRenderer.guideLinePaint)) {
            return false;
        }
        if (!this.guideLineStroke.equals(xYShapeRenderer.guideLineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        XYShapeRenderer xYShapeRenderer = (XYShapeRenderer)super.clone();
        if (this.paintScale instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.paintScale);
            xYShapeRenderer.paintScale = (PaintScale)publicCloneable.clone();
        }
        return xYShapeRenderer;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.guideLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.guideLineStroke = SerialUtilities.readStroke(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.guideLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.guideLineStroke, objectOutputStream);
    }
}

