/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.Effect3D;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XYLine3DRenderer
extends XYLineAndShapeRenderer
implements Effect3D,
Serializable {
    private static final long serialVersionUID = 588933208243446087L;
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset = 12.0;
    private double yOffset = 8.0;
    private transient Paint wallPaint = DEFAULT_WALL_PAINT;

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public void setXOffset(double d) {
        this.xOffset = d;
        this.fireChangeEvent();
    }

    public void setYOffset(double d) {
        this.yOffset = d;
        this.fireChangeEvent();
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 3;
    }

    protected boolean isLinePass(int n) {
        return n == 0 || n == 1;
    }

    protected boolean isItemPass(int n) {
        return n == 2;
    }

    protected boolean isShadowPass(int n) {
        return n == 0;
    }

    protected void drawFirstPassShape(Graphics2D graphics2D, int n, int n2, int n3, Shape shape) {
        if (this.isShadowPass(n)) {
            if (this.getWallPaint() != null) {
                graphics2D.setStroke(this.getItemStroke(n2, n3));
                graphics2D.setPaint(this.getWallPaint());
                graphics2D.translate(this.getXOffset(), this.getYOffset());
                graphics2D.draw(shape);
                graphics2D.translate(-this.getXOffset(), -this.getYOffset());
            }
        } else {
            super.drawFirstPassShape(graphics2D, n, n2, n3, shape);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYLine3DRenderer)) {
            return false;
        }
        XYLine3DRenderer xYLine3DRenderer = (XYLine3DRenderer)object;
        if (this.xOffset != xYLine3DRenderer.xOffset) {
            return false;
        }
        if (this.yOffset != xYLine3DRenderer.yOffset) {
            return false;
        }
        if (!PaintUtilities.equal(this.wallPaint, xYLine3DRenderer.wallPaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.wallPaint = SerialUtilities.readPaint(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.wallPaint, objectOutputStream);
    }
}

