/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class XYDotRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -2764344339073566425L;
    private int dotWidth = 1;
    private int dotHeight = 1;
    private transient Shape legendShape = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);

    public int getDotWidth() {
        return this.dotWidth;
    }

    public void setDotWidth(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Requires w > 0.");
        }
        this.dotWidth = n;
        this.fireChangeEvent();
    }

    public int getDotHeight() {
        return this.dotHeight;
    }

    public void setDotHeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Requires h > 0.");
        }
        this.dotHeight = n;
        this.fireChangeEvent();
    }

    public Shape getLegendShape() {
        return this.legendShape;
    }

    public void setLegendShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendShape = shape;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = (double)(this.dotWidth - 1) / 2.0;
        double d4 = (double)(this.dotHeight - 1) / 2.0;
        if (!Double.isNaN(d2)) {
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d5 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge) - d3;
            double d6 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2) - d4;
            graphics2D.setPaint(this.getItemPaint(n, n2));
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.fillRect((int)d6, (int)d5, this.dotHeight, this.dotWidth);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                graphics2D.fillRect((int)d5, (int)d6, this.dotWidth, this.dotHeight);
            }
            int n4 = xYPlot.getDomainAxisIndex(valueAxis);
            int n5 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d, d2, n4, n5, d5, d6, plotOrientation);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n);
        if (xYDataset == null) {
            return null;
        }
        LegendItem legendItem = null;
        if (this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.lookupSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.getLegendShape(), paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint2 = this.lookupLegendTextPaint(n2);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
        }
        return legendItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYDotRenderer)) {
            return false;
        }
        XYDotRenderer xYDotRenderer = (XYDotRenderer)object;
        if (this.dotWidth != xYDotRenderer.dotWidth) {
            return false;
        }
        if (this.dotHeight != xYDotRenderer.dotHeight) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendShape, xYDotRenderer.legendShape)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendShape = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendShape, objectOutputStream);
    }
}

