/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.BoxAndWhiskerXYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.Outlier;
import ai.org.jfree.chart.renderer.OutlierList;
import ai.org.jfree.chart.renderer.OutlierListCollection;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XYBoxAndWhiskerRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8020170108532232324L;
    private double boxWidth;
    private transient Paint boxPaint;
    private boolean fillBox;
    private transient Paint artifactPaint = Color.black;

    public XYBoxAndWhiskerRenderer() {
        this(-1.0);
    }

    public XYBoxAndWhiskerRenderer(double d) {
        this.boxWidth = d;
        this.boxPaint = Color.green;
        this.fillBox = true;
        this.setBaseToolTipGenerator(new BoxAndWhiskerXYToolTipGenerator());
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double d) {
        if (d != this.boxWidth) {
            this.boxWidth = d;
            this.fireChangeEvent();
        }
    }

    public Paint getBoxPaint() {
        return this.boxPaint;
    }

    public void setBoxPaint(Paint paint) {
        this.boxPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean bl) {
        this.fillBox = bl;
        this.fireChangeEvent();
    }

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.artifactPaint = paint;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    protected Paint lookupBoxPaint(int n, int n2) {
        Paint paint = this.getBoxPaint();
        if (paint != null) {
            return paint;
        }
        return this.getItemPaint(n, n2);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
        Number number = boxAndWhiskerXYDataset.getX(n, n2);
        Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n, n2);
        Number number3 = boxAndWhiskerXYDataset.getMinRegularValue(n, n2);
        Number number4 = boxAndWhiskerXYDataset.getMedianValue(n, n2);
        Number number5 = boxAndWhiskerXYDataset.getMeanValue(n, n2);
        Number number6 = boxAndWhiskerXYDataset.getQ1Value(n, n2);
        Number number7 = boxAndWhiskerXYDataset.getQ3Value(n, n2);
        double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = 0.0;
        if (number5 != null) {
            d6 = valueAxis2.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        }
        double d7 = valueAxis2.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
        double d8 = valueAxis2.valueToJava2D(number7.doubleValue(), rectangle2D, rectangleEdge);
        double d9 = d = this.getBoxWidth();
        double d10 = rectangle2D.getHeight();
        double d11 = 0.1;
        double d12 = d10 * d11;
        if (d <= 0.0) {
            int n4 = boxAndWhiskerXYDataset.getItemCount(n);
            d = d10 / (double)n4 * 4.5 / 7.0;
            d9 = d < 3.0 ? 3.0 : (d > d12 ? d12 : d);
        }
        graphics2D.setPaint(this.getItemPaint(n, n2));
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        graphics2D.draw(new Line2D.Double(d3, d2, d8, d2));
        graphics2D.draw(new Line2D.Double(d3, d2 - d9 / 2.0, d3, d2 + d9 / 2.0));
        graphics2D.draw(new Line2D.Double(d4, d2, d7, d2));
        graphics2D.draw(new Line2D.Double(d4, d2 - d9 / 2.0, d4, d2 + d9 / 2.0));
        Rectangle2D.Double double_ = null;
        double_ = d7 < d8 ? new Rectangle2D.Double(d7, d2 - d9 / 2.0, d8 - d7, d9) : new Rectangle2D.Double(d8, d2 - d9 / 2.0, d7 - d8, d9);
        if (this.fillBox) {
            graphics2D.setPaint(this.lookupBoxPaint(n, n2));
            graphics2D.fill(double_);
        }
        graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
        graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
        graphics2D.draw(double_);
        graphics2D.setPaint(this.getArtifactPaint());
        graphics2D.draw(new Line2D.Double(d5, d2 - d9 / 2.0, d5, d2 + d9 / 2.0));
        if (number5 != null) {
            double d13 = d9 / 4.0;
            if (d6 > rectangle2D.getMinX() - d13 && d6 < rectangle2D.getMaxX() + d13) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(d6 - d13, d2 - d13, d13 * 2.0, d13 * 2.0);
                graphics2D.fill(double_2);
                graphics2D.draw(double_2);
            }
        }
        if (entityCollection != null && double_.intersects(rectangle2D)) {
            this.addEntity(entityCollection, double_, xYDataset, n, n2, d6, d2);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Cloneable cloneable;
        double d;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
        Number number = boxAndWhiskerXYDataset.getX(n, n2);
        Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n, n2);
        Number number3 = boxAndWhiskerXYDataset.getMinRegularValue(n, n2);
        Number number4 = boxAndWhiskerXYDataset.getMedianValue(n, n2);
        Number number5 = boxAndWhiskerXYDataset.getMeanValue(n, n2);
        Number number6 = boxAndWhiskerXYDataset.getQ1Value(n, n2);
        Number number7 = boxAndWhiskerXYDataset.getQ3Value(n, n2);
        List list = boxAndWhiskerXYDataset.getOutliers(n, n2);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = 0.0;
        if (number5 != null) {
            d6 = valueAxis2.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        }
        double d7 = valueAxis2.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
        double d8 = valueAxis2.valueToJava2D(number7.doubleValue(), rectangle2D, rectangleEdge);
        double d9 = d = this.getBoxWidth();
        double d10 = rectangle2D.getMaxX() - rectangle2D.getMinX();
        double d11 = 0.1;
        double d12 = d10 * d11;
        if (d <= 0.0) {
            int n4 = boxAndWhiskerXYDataset.getItemCount(n);
            d = d10 / (double)n4 * 4.5 / 7.0;
            d9 = d < 3.0 ? 3.0 : (d > d12 ? d12 : d);
        }
        graphics2D.setPaint(this.getItemPaint(n, n2));
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        graphics2D.draw(new Line2D.Double(d2, d3, d2, d8));
        graphics2D.draw(new Line2D.Double(d2 - d9 / 2.0, d3, d2 + d9 / 2.0, d3));
        graphics2D.draw(new Line2D.Double(d2, d4, d2, d7));
        graphics2D.draw(new Line2D.Double(d2 - d9 / 2.0, d4, d2 + d9 / 2.0, d4));
        Rectangle2D.Double double_ = null;
        double_ = d7 > d8 ? new Rectangle2D.Double(d2 - d9 / 2.0, d8, d9, d7 - d8) : new Rectangle2D.Double(d2 - d9 / 2.0, d7, d9, d8 - d7);
        if (this.fillBox) {
            graphics2D.setPaint(this.lookupBoxPaint(n, n2));
            graphics2D.fill(double_);
        }
        graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
        graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
        graphics2D.draw(double_);
        graphics2D.setPaint(this.getArtifactPaint());
        graphics2D.draw(new Line2D.Double(d2 - d9 / 2.0, d5, d2 + d9 / 2.0, d5));
        double d13 = 0.0;
        double d14 = d9 / 3.0;
        if (number5 != null) {
            d13 = d9 / 4.0;
            if (d6 > rectangle2D.getMinY() - d13 && d6 < rectangle2D.getMaxY() + d13) {
                cloneable = new Ellipse2D.Double(d2 - d13, d6 - d13, d13 * 2.0, d13 * 2.0);
                graphics2D.fill((Shape)((Object)cloneable));
                graphics2D.draw((Shape)((Object)cloneable));
            }
        }
        cloneable = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        for (int i = 0; i < list.size(); ++i) {
            double d15;
            double d16 = ((Number)list.get(i)).doubleValue();
            if (d16 > boxAndWhiskerXYDataset.getMaxOutlier(n, n2).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d16 < boxAndWhiskerXYDataset.getMinOutlier(n, n2).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d16 > boxAndWhiskerXYDataset.getMaxRegularValue(n, n2).doubleValue()) {
                d15 = valueAxis2.valueToJava2D(d16, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d2, d15, d14));
            } else if (d16 < boxAndWhiskerXYDataset.getMinRegularValue(n, n2).doubleValue()) {
                d15 = valueAxis2.valueToJava2D(d16, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d2, d15, d14));
            }
            Collections.sort(cloneable);
        }
        Iterator iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            Outlier outlier = (Outlier)iterator.next();
            outlierListCollection.add(outlier);
        }
        double d17 = valueAxis2.valueToJava2D(valueAxis2.getUpperBound(), rectangle2D, rectangleEdge) + d13;
        double d18 = valueAxis2.valueToJava2D(valueAxis2.getLowerBound(), rectangle2D, rectangleEdge) - d13;
        Iterator iterator2 = outlierListCollection.iterator();
        while (iterator2.hasNext()) {
            OutlierList outlierList = (OutlierList)iterator2.next();
            Outlier outlier = outlierList.getAveragedOutlier();
            Point2D point2D = outlier.getPoint();
            if (outlierList.isMultiple()) {
                this.drawMultipleEllipse(point2D, d9, d14, graphics2D);
                continue;
            }
            this.drawEllipse(point2D, d14, graphics2D);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d13, graphics2D, d2, d17);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d13, graphics2D, d2, d18);
        }
        if (entityCollection != null && double_.intersects(rectangle2D)) {
            this.addEntity(entityCollection, double_, xYDataset, n, n2, d2, d6);
        }
    }

    protected void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    protected void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    protected void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    protected void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBoxAndWhiskerRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = (XYBoxAndWhiskerRenderer)object;
        if (this.boxWidth != xYBoxAndWhiskerRenderer.getBoxWidth()) {
            return false;
        }
        if (!PaintUtilities.equal(this.boxPaint, xYBoxAndWhiskerRenderer.boxPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.artifactPaint, xYBoxAndWhiskerRenderer.artifactPaint)) {
            return false;
        }
        return this.fillBox == xYBoxAndWhiskerRenderer.fillBox;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.boxPaint, objectOutputStream);
        SerialUtilities.writePaint(this.artifactPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.boxPaint = SerialUtilities.readPaint(objectInputStream);
        this.artifactPaint = SerialUtilities.readPaint(objectInputStream);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

