/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.ItemLabelAnchor;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.GradientXYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 770559577251370036L;
    private static XYBarPainter defaultBarPainter = new GradientXYBarPainter();
    private static boolean defaultShadowsVisible = true;
    private double base;
    private boolean useYInterval;
    private double margin;
    private boolean drawBarOutline;
    private GradientPaintTransformer gradientPaintTransformer;
    private transient Shape legendBar;
    private ItemLabelPosition positiveItemLabelPositionFallback;
    private ItemLabelPosition negativeItemLabelPositionFallback;
    private XYBarPainter barPainter;
    private boolean shadowsVisible;
    private double shadowXOffset;
    private double shadowYOffset;
    private double barAlignmentFactor;

    public static XYBarPainter getDefaultBarPainter() {
        return defaultBarPainter;
    }

    public static void setDefaultBarPainter(XYBarPainter xYBarPainter) {
        if (xYBarPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        defaultBarPainter = xYBarPainter;
    }

    public static boolean getDefaultShadowsVisible() {
        return defaultShadowsVisible;
    }

    public static void setDefaultShadowsVisible(boolean bl) {
        defaultShadowsVisible = bl;
    }

    public XYBarRenderer() {
        this(0.0);
    }

    public XYBarRenderer(double d) {
        this.margin = d;
        this.base = 0.0;
        this.useYInterval = false;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
        this.drawBarOutline = false;
        this.legendBar = new Rectangle2D.Double(-3.0, -5.0, 6.0, 10.0);
        this.barPainter = XYBarRenderer.getDefaultBarPainter();
        this.shadowsVisible = XYBarRenderer.getDefaultShadowsVisible();
        this.shadowXOffset = 4.0;
        this.shadowYOffset = 4.0;
        this.barAlignmentFactor = -1.0;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        this.base = d;
        this.fireChangeEvent();
    }

    public boolean getUseYInterval() {
        return this.useYInterval;
    }

    public void setUseYInterval(boolean bl) {
        if (this.useYInterval != bl) {
            this.useYInterval = bl;
            this.fireChangeEvent();
        }
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d) {
        this.margin = d;
        this.fireChangeEvent();
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl) {
        this.drawBarOutline = bl;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    public Shape getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'bar' argument.");
        }
        this.legendBar = shape;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.positiveItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.negativeItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public XYBarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(XYBarPainter xYBarPainter) {
        if (xYBarPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = xYBarPainter;
        this.fireChangeEvent();
    }

    public boolean getShadowsVisible() {
        return this.shadowsVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowsVisible = bl;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
        this.fireChangeEvent();
    }

    public double getBarAlignmentFactor() {
        return this.barAlignmentFactor;
    }

    public void setBarAlignmentFactor(double d) {
        this.barAlignmentFactor = d;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYBarRendererState xYBarRendererState = new XYBarRendererState(plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxisForDataset(xYPlot.indexOf(xYDataset));
        xYBarRendererState.setG2Base(valueAxis.valueToJava2D(this.base, rectangle2D, xYPlot.getRangeAxisEdge()));
        return xYBarRendererState;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.legendBar;
            Paint paint = this.lookupSeriesPaint(n2);
            Paint paint2 = this.lookupSeriesOutlinePaint(n2);
            Stroke stroke = this.lookupSeriesOutlineStroke(n2);
            legendItem = this.drawBarOutline ? new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2) : new LegendItem(string, string2, string3, string4, shape, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint3 = this.lookupLegendTextPaint(n2);
            if (paint3 != null) {
                legendItem.setLabelPaint(paint3);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
            if (this.getGradientPaintTransformer() != null) {
                legendItem.setFillPaintTransformer(this.getGradientPaintTransformer());
            }
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d;
        double d2;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.useYInterval) {
            d2 = intervalXYDataset.getStartYValue(n, n2);
            d = intervalXYDataset.getEndYValue(n, n2);
        } else {
            d2 = this.base;
            d = intervalXYDataset.getYValue(n, n2);
        }
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return;
        }
        if (d2 <= d ? !valueAxis2.getRange().intersects(d2, d) : !valueAxis2.getRange().intersects(d, d2)) {
            return;
        }
        double d3 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d5 = Math.min(d3, d4);
        double d6 = Math.max(d3, d4);
        double d7 = intervalXYDataset.getStartXValue(n, n2);
        if (Double.isNaN(d7)) {
            return;
        }
        double d8 = intervalXYDataset.getEndXValue(n, n2);
        if (Double.isNaN(d8)) {
            return;
        }
        if (d7 <= d8 ? !valueAxis.getRange().intersects(d7, d8) : !valueAxis.getRange().intersects(d8, d7)) {
            return;
        }
        if (this.barAlignmentFactor >= 0.0 && this.barAlignmentFactor <= 1.0) {
            double d9 = intervalXYDataset.getXValue(n, n2);
            double d10 = d8 - d7;
            d7 = d9 - d10 * this.barAlignmentFactor;
            d8 = d7 + d10;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d11 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
        double d12 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        double d13 = Math.max(1.0, Math.abs(d12 - d11));
        double d14 = Math.min(d11, d12);
        if (this.getMargin() > 0.0) {
            double d15 = d13 * this.getMargin();
            d13 -= d15;
            d14 += d15 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d5 = Math.max(d5, rectangle2D.getMinX());
            d6 = Math.min(d6, rectangle2D.getMaxX());
            double_ = new Rectangle2D.Double(d5, d14, d6 - d5, d13);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d5 = Math.max(d5, rectangle2D.getMinY());
            d6 = Math.min(d6, rectangle2D.getMaxY());
            double_ = new Rectangle2D.Double(d14, d5, d13, d6 - d5);
        }
        boolean bl = d > 0.0;
        boolean bl2 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge2 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (this.getShadowsVisible()) {
            this.barPainter.paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge2, !this.useYInterval);
        }
        this.barPainter.paintBar(graphics2D, this, n, n2, double_, rectangleEdge2);
        if (this.isItemLabelVisible(n, n2)) {
            XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n, n2);
            this.drawItemLabel(graphics2D, xYDataset, n, n2, xYPlot, xYItemLabelGenerator, double_, d < 0.0);
        }
        double d16 = (d7 + d8) / 2.0;
        double d17 = xYDataset.getYValue(n, n2);
        double d18 = valueAxis.valueToJava2D(d16, rectangle2D, rectangleEdge);
        double d19 = valueAxis2.valueToJava2D(d17, rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYPlot.getDomainAxisIndex(valueAxis);
        int n5 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d16, d17, n4, n5, d18, d19, xYPlot.getOrientation());
        EntityCollection entityCollection = xYItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addEntity(entityCollection, double_, xYDataset, n, n2, 0.0, 0.0);
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, XYDataset xYDataset, int n, int n2, XYPlot xYPlot, XYItemLabelGenerator xYItemLabelGenerator, Rectangle2D rectangle2D, boolean bl) {
        Shape shape;
        if (xYItemLabelGenerator == null) {
            return;
        }
        String string = xYItemLabelGenerator.generateLabel(xYDataset, n, n2);
        if (string == null) {
            return;
        }
        Font font = this.getItemLabelFont(n, n2);
        graphics2D.setFont(font);
        Paint paint = this.getItemLabelPaint(n, n2);
        graphics2D.setPaint(paint);
        ItemLabelPosition itemLabelPosition = null;
        itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        if (this.isInternalAnchor(itemLabelPosition.getItemLabelAnchor()) && (shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor())) != null && !rectangle2D.contains(shape.getBounds2D()) && (itemLabelPosition = !bl ? this.getPositiveItemLabelPositionFallback() : this.getNegativeItemLabelPositionFallback()) != null) {
            point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, xYPlot.getOrientation());
        }
        if (itemLabelPosition != null) {
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        double d = this.getItemLabelAnchorOffset();
        double d2 = rectangle2D.getX() - d;
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getX() + d;
        double d5 = rectangle2D.getCenterX();
        double d6 = rectangle2D.getMaxX() - d;
        double d7 = rectangle2D.getMaxX();
        double d8 = rectangle2D.getMaxX() + d;
        double d9 = rectangle2D.getMaxY() + d;
        double d10 = rectangle2D.getMaxY();
        double d11 = rectangle2D.getMaxY() - d;
        double d12 = rectangle2D.getCenterY();
        double d13 = rectangle2D.getMinY() + d;
        double d14 = rectangle2D.getMinY();
        double d15 = rectangle2D.getMinY() - d;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d6, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d6, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d6, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d5, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d4, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d4, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d4, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d5, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d7, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d8, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d8, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d8, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d7, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d5, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d3, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d2, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d2, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d2, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d3, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d5, d15);
        }
        return double_;
    }

    private boolean isInternalAnchor(ItemLabelAnchor itemLabelAnchor) {
        return itemLabelAnchor == ItemLabelAnchor.CENTER || itemLabelAnchor == ItemLabelAnchor.INSIDE1 || itemLabelAnchor == ItemLabelAnchor.INSIDE2 || itemLabelAnchor == ItemLabelAnchor.INSIDE3 || itemLabelAnchor == ItemLabelAnchor.INSIDE4 || itemLabelAnchor == ItemLabelAnchor.INSIDE5 || itemLabelAnchor == ItemLabelAnchor.INSIDE6 || itemLabelAnchor == ItemLabelAnchor.INSIDE7 || itemLabelAnchor == ItemLabelAnchor.INSIDE8 || itemLabelAnchor == ItemLabelAnchor.INSIDE9 || itemLabelAnchor == ItemLabelAnchor.INSIDE10 || itemLabelAnchor == ItemLabelAnchor.INSIDE11 || itemLabelAnchor == ItemLabelAnchor.INSIDE12;
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findDomainBounds(xYDataset, true);
        }
        return null;
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findRangeBounds(xYDataset, this.useYInterval);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        XYBarRenderer xYBarRenderer = (XYBarRenderer)super.clone();
        if (this.gradientPaintTransformer != null) {
            xYBarRenderer.gradientPaintTransformer = (GradientPaintTransformer)ObjectUtilities.clone(this.gradientPaintTransformer);
        }
        xYBarRenderer.legendBar = ShapeUtilities.clone(this.legendBar);
        return xYBarRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBarRenderer)) {
            return false;
        }
        XYBarRenderer xYBarRenderer = (XYBarRenderer)object;
        if (this.base != xYBarRenderer.base) {
            return false;
        }
        if (this.drawBarOutline != xYBarRenderer.drawBarOutline) {
            return false;
        }
        if (this.margin != xYBarRenderer.margin) {
            return false;
        }
        if (this.useYInterval != xYBarRenderer.useYInterval) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, xYBarRenderer.gradientPaintTransformer)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendBar, xYBarRenderer.legendBar)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionFallback, xYBarRenderer.positiveItemLabelPositionFallback)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionFallback, xYBarRenderer.negativeItemLabelPositionFallback)) {
            return false;
        }
        if (!this.barPainter.equals(xYBarRenderer.barPainter)) {
            return false;
        }
        if (this.shadowsVisible != xYBarRenderer.shadowsVisible) {
            return false;
        }
        if (this.shadowXOffset != xYBarRenderer.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != xYBarRenderer.shadowYOffset) {
            return false;
        }
        if (this.barAlignmentFactor != xYBarRenderer.barAlignmentFactor) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendBar = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendBar, objectOutputStream);
    }

    protected class XYBarRendererState
    extends XYItemRendererState {
        private double g2Base;

        public XYBarRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public double getG2Base() {
            return this.g2Base;
        }

        public void setG2Base(double d) {
            this.g2Base = d;
        }
    }
}

