/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.XYItemEntity;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class XYAreaRenderer2
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -7378069681579984133L;
    private boolean showOutline = false;
    private transient Shape legendArea;

    public XYAreaRenderer2() {
        this(null, null);
    }

    public XYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -4.0f);
        generalPath.lineTo(3.0f, -2.0f);
        generalPath.lineTo(4.0f, 4.0f);
        generalPath.lineTo(-4.0f, 4.0f);
        generalPath.lineTo(-3.0f, -2.0f);
        generalPath.closePath();
        this.legendArea = generalPath;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
        this.fireChangeEvent();
    }

    public boolean getPlotLines() {
        return false;
    }

    public Shape getLegendArea() {
        return this.legendArea;
    }

    public void setLegendArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.legendArea = shape;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.lookupSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.legendArea, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint2 = this.lookupLegendTextPaint(n2);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d5 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d6 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d6)) {
            d6 = 0.0;
        }
        double d7 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getDomainAxisEdge());
        double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        double d9 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d10 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d10)) {
            d10 = 0.0;
        }
        double d11 = valueAxis.valueToJava2D(d9, rectangle2D, xYPlot.getDomainAxisEdge());
        double d12 = valueAxis2.valueToJava2D(d10, rectangle2D, xYPlot.getRangeAxisEdge());
        double d13 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        GeneralPath generalPath = new GeneralPath();
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRenderer2.moveTo(generalPath, d13, (d7 + d3) / 2.0);
            XYAreaRenderer2.lineTo(generalPath, (d8 + d4) / 2.0, (d7 + d3) / 2.0);
            XYAreaRenderer2.lineTo(generalPath, d4, d3);
            XYAreaRenderer2.lineTo(generalPath, (d4 + d12) / 2.0, (d3 + d11) / 2.0);
            XYAreaRenderer2.lineTo(generalPath, d13, (d3 + d11) / 2.0);
        } else {
            XYAreaRenderer2.moveTo(generalPath, (d7 + d3) / 2.0, d13);
            XYAreaRenderer2.lineTo(generalPath, (d7 + d3) / 2.0, (d8 + d4) / 2.0);
            XYAreaRenderer2.lineTo(generalPath, d3, d4);
            XYAreaRenderer2.lineTo(generalPath, (d3 + d11) / 2.0, (d4 + d12) / 2.0);
            XYAreaRenderer2.lineTo(generalPath, (d3 + d11) / 2.0, d13);
        }
        generalPath.closePath();
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.fill(generalPath);
        if (this.isOutline()) {
            graphics2D.setStroke(this.lookupSeriesOutlineStroke(n));
            graphics2D.setPaint(this.lookupSeriesOutlinePaint(n));
            graphics2D.draw(generalPath);
        }
        int n5 = xYPlot.getDomainAxisIndex(valueAxis);
        int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d, d2, n5, n6, d3, d4, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(generalPath, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYAreaRenderer2)) {
            return false;
        }
        XYAreaRenderer2 xYAreaRenderer2 = (XYAreaRenderer2)object;
        if (this.showOutline != xYAreaRenderer2.showOutline) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendArea, xYAreaRenderer2.legendArea)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        XYAreaRenderer2 xYAreaRenderer2 = (XYAreaRenderer2)super.clone();
        xYAreaRenderer2.legendArea = ShapeUtilities.clone(this.legendArea);
        return xYAreaRenderer2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendArea = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendArea, objectOutputStream);
    }
}

