/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.BooleanList;
import ai.org.jfree.util.BooleanUtilities;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import ai.org.jfree.util.UnitType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3271351259436865995L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean baseShapesVisible;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private UnitType gapThresholdType = UnitType.RELATIVE;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawSeriesLineAsPath;
    private transient Shape legendLine;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int n) {
        this(n, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if ((n & 1) != 0) {
            this.baseShapesVisible = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.drawSeriesLineAsPath = false;
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean bl) {
        if (this.baseShapesVisible != bl) {
            this.baseShapesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.baseShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtilities.valueOf(bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
        this.fireChangeEvent();
    }

    public Boolean getSeriesShapesFilled(int n) {
        return this.seriesShapesFilled.getBoolean(n);
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
        this.fireChangeEvent();
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl) {
        this.baseShapesFilled = bl;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.fireChangeEvent();
        }
    }

    public UnitType getGapThresholdType() {
        return this.gapThresholdType;
    }

    public void setGapThresholdType(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'thresholdType' argument.");
        }
        this.gapThresholdType = unitType;
        this.fireChangeEvent();
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d) {
        this.gapThreshold = d;
        this.fireChangeEvent();
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        if (this.plotImages != bl) {
            this.plotImages = bl;
            this.fireChangeEvent();
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public void setPlotDiscontinuous(boolean bl) {
        if (this.plotDiscontinuous != bl) {
            this.plotDiscontinuous = bl;
            this.fireChangeEvent();
        }
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
        this.drawSeriesLineAsPath = bl;
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        LegendItem legendItem = null;
        XYDataset xYDataset = xYPlot.getDataset(n);
        if (xYDataset != null && this.getItemVisible(n2, 0)) {
            Paint paint;
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.lookupLegendShape(n2);
            boolean bl = this.getItemShapeFilled(n2, 0);
            Paint paint2 = paint = this.lookupSeriesPaint(n2);
            Stroke stroke = this.lookupSeriesStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.baseShapesVisible, shape, bl, paint, !bl, paint, stroke, this.plotLines, this.legendLine, stroke, paint2);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint3 = this.lookupLegendTextPaint(n2);
            if (paint3 != null) {
                legendItem.setLabelPaint(paint3);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
        }
        return legendItem;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.seriesIndex = -1;
        return state;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        int n4;
        int n5;
        Object object;
        boolean bl = this.getItemVisible(n, n2);
        Object object2 = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            bl = false;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.getPlotLines()) {
            if (this.drawSeriesLineAsPath) {
                object = (State)xYItemRendererState;
                if (((State)object).getSeriesIndex() != n) {
                    ((State)object).seriesPath.reset();
                    ((State)object).lastPointGood = false;
                    ((State)object).setSeriesIndex(n);
                }
                if (bl && !Double.isNaN(d3) && !Double.isNaN(d4)) {
                    float f = (float)d3;
                    float f2 = (float)d4;
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        f = (float)d4;
                        f2 = (float)d3;
                    }
                    if (((State)object).isLastPointGood()) {
                        ((State)object).seriesPath.lineTo(f, f2);
                    } else {
                        ((State)object).seriesPath.moveTo(f, f2);
                    }
                    ((State)object).setLastPointGood(true);
                } else {
                    ((State)object).setLastPointGood(false);
                }
                if (n2 == xYDataset.getItemCount(n) - 1 && ((State)object).seriesIndex == n) {
                    graphics2D.setStroke(this.lookupSeriesStroke(n));
                    graphics2D.setPaint(this.lookupSeriesPaint(n));
                    graphics2D.draw(((State)object).seriesPath);
                }
            } else if (n2 != 0 && bl) {
                double d5 = xYDataset.getXValue(n, n2 - 1);
                double d6 = xYDataset.getYValue(n, n2 - 1);
                if (!Double.isNaN(d5) && !Double.isNaN(d6)) {
                    n5 = 1;
                    if (this.getPlotDiscontinuous()) {
                        n4 = xYDataset.getItemCount(n);
                        double d7 = xYDataset.getXValue(n, 0);
                        double d8 = xYDataset.getXValue(n, n4 - 1);
                        if (this.gapThresholdType == UnitType.ABSOLUTE) {
                            n5 = Math.abs(d - d5) <= this.gapThreshold ? 1 : 0;
                        } else {
                            int n6 = n5 = Math.abs(d - d5) <= (d8 - d7) / (double)n4 * this.getGapThreshold() ? 1 : 0;
                        }
                    }
                    if (n5 != 0) {
                        double d9 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
                        double d10 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                        if (Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d3) || Double.isNaN(d4)) {
                            return;
                        }
                        if (plotOrientation == PlotOrientation.HORIZONTAL) {
                            xYItemRendererState.workingLine.setLine(d10, d9, d4, d3);
                        } else if (plotOrientation == PlotOrientation.VERTICAL) {
                            xYItemRendererState.workingLine.setLine(d9, d10, d3, d4);
                        }
                        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                            graphics2D.draw(xYItemRendererState.workingLine);
                        }
                    }
                }
            }
        }
        if (!bl) {
            return;
        }
        if (this.getBaseShapesVisible()) {
            object = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d4, d3);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d3, d4);
            }
            if (object.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill((Shape)object);
                } else {
                    graphics2D.draw((Shape)object);
                }
            }
            object2 = object;
        }
        if (this.getPlotImages() && (object = this.getImage(xYPlot, n, n2, d3, d4)) != null) {
            Point point = this.getImageHotspot(xYPlot, n, n2, d3, d4, (Image)object);
            graphics2D.drawImage((Image)object, (int)(d3 - point.getX()), (int)(d4 - point.getY()), null);
            object2 = new Rectangle2D.Double(d3 - point.getX(), d4 - point.getY(), ((Image)object).getWidth(null), ((Image)object).getHeight(null));
        }
        double d11 = d3;
        double d12 = d4;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d11 = d4;
            d12 = d3;
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d11, d12, d2 < 0.0);
        }
        n5 = xYPlot.getDomainAxisIndex(valueAxis);
        n4 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d, d2, n5, n4, d3, d4, plotOrientation);
        if (entityCollection != null && StandardXYItemRenderer.isPointInRect(rectangle2D, d11, d12)) {
            this.addEntity(entityCollection, (Shape)object2, xYDataset, n, n2, d11, d12);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYItemRenderer)) {
            return false;
        }
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
        if (this.baseShapesVisible != standardXYItemRenderer.baseShapesVisible) {
            return false;
        }
        if (this.plotLines != standardXYItemRenderer.plotLines) {
            return false;
        }
        if (this.plotImages != standardXYItemRenderer.plotImages) {
            return false;
        }
        if (this.plotDiscontinuous != standardXYItemRenderer.plotDiscontinuous) {
            return false;
        }
        if (this.gapThresholdType != standardXYItemRenderer.gapThresholdType) {
            return false;
        }
        if (this.gapThreshold != standardXYItemRenderer.gapThreshold) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesFilled, standardXYItemRenderer.shapesFilled)) {
            return false;
        }
        if (!this.seriesShapesFilled.equals(standardXYItemRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != standardXYItemRenderer.baseShapesFilled) {
            return false;
        }
        if (this.drawSeriesLineAsPath != standardXYItemRenderer.drawSeriesLineAsPath) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, standardXYItemRenderer.legendLine)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)super.clone();
        standardXYItemRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        standardXYItemRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        return standardXYItemRenderer;
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    public static class State
    extends XYItemRendererState {
        public GeneralPath seriesPath;
        private int seriesIndex;
        private boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean bl) {
            this.lastPointGood = bl;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public void setSeriesIndex(int n) {
            this.seriesIndex = n;
        }
    }
}

