/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SamplingXYLineRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private transient Shape legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);

    public SamplingXYLineRenderer() {
        this.setBaseLegendShape(this.legendLine);
        this.setTreatLegendShapeAsLine(true);
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 1;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        double d = 72.0;
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.intervalPath = new GeneralPath();
        state.dX = 72.0 / d;
        return state;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        State state = (State)xYItemRendererState;
        if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
            float f = (float)d3;
            float f2 = (float)d4;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                f = (float)d4;
                f2 = (float)d3;
            }
            if (state.lastPointGood) {
                if (Math.abs((double)f - state.lastX) > state.dX) {
                    state.seriesPath.lineTo(f, f2);
                    if (state.lowY < state.highY) {
                        state.intervalPath.moveTo((float)state.lastX, (float)state.lowY);
                        state.intervalPath.lineTo((float)state.lastX, (float)state.highY);
                    }
                    state.lastX = f;
                    state.openY = f2;
                    state.highY = f2;
                    state.lowY = f2;
                    state.closeY = f2;
                } else {
                    state.highY = Math.max(state.highY, (double)f2);
                    state.lowY = Math.min(state.lowY, (double)f2);
                    state.closeY = f2;
                }
            } else {
                state.seriesPath.moveTo(f, f2);
                state.lastX = f;
                state.openY = f2;
                state.highY = f2;
                state.lowY = f2;
                state.closeY = f2;
            }
            state.lastPointGood = true;
        } else {
            state.lastPointGood = false;
        }
        if (n2 == state.getLastItemIndex()) {
            PathIterator pathIterator = state.seriesPath.getPathIterator(null);
            int n4 = 0;
            while (!pathIterator.isDone()) {
                ++n4;
                pathIterator.next();
            }
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.draw(state.seriesPath);
            graphics2D.draw(state.intervalPath);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SamplingXYLineRenderer samplingXYLineRenderer = (SamplingXYLineRenderer)super.clone();
        if (this.legendLine != null) {
            samplingXYLineRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        }
        return samplingXYLineRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SamplingXYLineRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SamplingXYLineRenderer samplingXYLineRenderer = (SamplingXYLineRenderer)object;
        return ShapeUtilities.equal(this.legendLine, samplingXYLineRenderer.legendLine);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    public static class State
    extends XYItemRendererState {
        GeneralPath seriesPath;
        GeneralPath intervalPath;
        double dX = 1.0;
        double lastX;
        double openY = 0.0;
        double highY = 0.0;
        double lowY = 0.0;
        double closeY = 0.0;
        boolean lastPointGood;

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public void startSeriesPass(XYDataset xYDataset, int n, int n2, int n3, int n4, int n5) {
            this.seriesPath.reset();
            this.intervalPath.reset();
            this.lastPointGood = false;
            super.startSeriesPass(xYDataset, n, n2, n3, n4, n5);
        }
    }
}

