/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.OHLCDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class HighLowRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8135673815876552516L;
    private boolean drawOpenTicks = true;
    private boolean drawCloseTicks = true;
    private transient Paint openTickPaint;
    private transient Paint closeTickPaint;
    private double tickLength = 2.0;

    public boolean getDrawOpenTicks() {
        return this.drawOpenTicks;
    }

    public void setDrawOpenTicks(boolean bl) {
        this.drawOpenTicks = bl;
        this.fireChangeEvent();
    }

    public boolean getDrawCloseTicks() {
        return this.drawCloseTicks;
    }

    public void setDrawCloseTicks(boolean bl) {
        this.drawCloseTicks = bl;
        this.fireChangeEvent();
    }

    public Paint getOpenTickPaint() {
        return this.openTickPaint;
    }

    public void setOpenTickPaint(Paint paint) {
        this.openTickPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getCloseTickPaint() {
        return this.closeTickPaint;
    }

    public void setCloseTickPaint(Paint paint) {
        this.closeTickPaint = paint;
        this.fireChangeEvent();
    }

    public double getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(double d) {
        this.tickLength = d;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findRangeBounds(xYDataset, true);
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d = xYDataset.getXValue(n, n2);
        if (!valueAxis.getRange().contains(d)) {
            return;
        }
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (xYDataset instanceof OHLCDataset) {
            double d3;
            double d4;
            double d5;
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            double d6 = oHLCDataset.getHighValue(n, n2);
            double d7 = oHLCDataset.getLowValue(n, n2);
            if (!Double.isNaN(d6) && !Double.isNaN(d7)) {
                d5 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge);
                d4 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge);
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d4, d2, d5, d2));
                    double_ = new Rectangle2D.Double(Math.min(d4, d5), d2 - 1.0, Math.abs(d5 - d4), 2.0);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d2, d4, d2, d5));
                    double_ = new Rectangle2D.Double(d2 - 1.0, Math.min(d4, d5), 2.0, Math.abs(d5 - d4));
                }
            }
            d5 = this.getTickLength();
            if (valueAxis.isInverted()) {
                d5 = -d5;
            }
            if (this.getDrawOpenTicks() && !Double.isNaN(d4 = oHLCDataset.getOpenValue(n, n2))) {
                d3 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge);
                if (this.openTickPaint != null) {
                    graphics2D.setPaint(this.openTickPaint);
                } else {
                    graphics2D.setPaint(paint);
                }
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d3, d2 + d5, d3, d2));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d2 - d5, d3, d2, d3));
                }
            }
            if (this.getDrawCloseTicks() && !Double.isNaN(d4 = oHLCDataset.getCloseValue(n, n2))) {
                d3 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge);
                if (this.closeTickPaint != null) {
                    graphics2D.setPaint(this.closeTickPaint);
                } else {
                    graphics2D.setPaint(paint);
                }
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d3, d2, d3, d2 - d5));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d2, d3, d2 + d5, d3));
                }
            }
        } else if (n2 > 0) {
            double d8 = xYDataset.getXValue(n, n2 - 1);
            double d9 = xYDataset.getYValue(n, n2 - 1);
            double d10 = xYDataset.getYValue(n, n2);
            if (Double.isNaN(d8) || Double.isNaN(d9) || Double.isNaN(d10)) {
                return;
            }
            double d11 = valueAxis.valueToJava2D(d8, rectangle2D, xYPlot.getDomainAxisEdge());
            double d12 = valueAxis2.valueToJava2D(d9, rectangle2D, rectangleEdge);
            double d13 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.draw(new Line2D.Double(d12, d11, d13, d2));
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                graphics2D.draw(new Line2D.Double(d11, d12, d2, d13));
            }
        }
        if (entityCollection != null) {
            this.addEntity(entityCollection, double_, xYDataset, n, n2, 0.0, 0.0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HighLowRenderer)) {
            return false;
        }
        HighLowRenderer highLowRenderer = (HighLowRenderer)object;
        if (this.drawOpenTicks != highLowRenderer.drawOpenTicks) {
            return false;
        }
        if (this.drawCloseTicks != highLowRenderer.drawCloseTicks) {
            return false;
        }
        if (!PaintUtilities.equal(this.openTickPaint, highLowRenderer.openTickPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.closeTickPaint, highLowRenderer.closeTickPaint)) {
            return false;
        }
        if (this.tickLength != highLowRenderer.tickLength) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.openTickPaint = SerialUtilities.readPaint(objectInputStream);
        this.closeTickPaint = SerialUtilities.readPaint(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.openTickPaint, objectOutputStream);
        SerialUtilities.writePaint(this.closeTickPaint, objectOutputStream);
    }
}

